% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_features_heatmap}
\alias{plot_features_heatmap}
\alias{plot_KOs_heatmap}
\title{Plot features heatmap}
\usage{
plot_features_heatmap(
  kodf,
  group = NULL,
  metadata = NULL,
  map_id = "map00780",
  select_ko = NULL,
  only_sig = FALSE,
  columns = NULL,
  modulelist = NULL,
  KO_description = FALSE,
  str_width = 50,
  heatmap_param = list()
)
}
\arguments{
\item{kodf}{KO_abundance table, rowname is ko id (e.g. K00001),colnames is samples. or result of `get_reporter_score`}

\item{group}{The compare group (two category) in your data, one column name of metadata when metadata exist or a vector whose length equal to columns number of kodf.}

\item{metadata}{metadata}

\item{map_id}{the pathway or module id}

\item{select_ko}{select which ko}

\item{only_sig}{only show the significant KOs}

\item{columns}{change columns}

\item{modulelist}{NULL or customized modulelist dataframe, must contain "id","K_num","KOs","Description" columns. Take the `KOlist` as example, use \code{\link{custom_modulelist}}.}

\item{KO_description}{show KO description rather than KO id.}

\item{str_width}{str_width to wrap}

\item{heatmap_param}{parameters pass to \code{\link[pheatmap]{pheatmap}}}
}
\value{
ggplot
}
\description{
Plot features heatmap
}
\examples{
\donttest{
if (requireNamespace("pheatmap")) {
  data("reporter_score_res")
  plot_features_heatmap(reporter_score_res, map_id = "map00780")
}
}
}
