\name{logit.env}
\alias{logit.env}
\title{Fit the envelope model in logistic regression}
\description{
 Fit the envelope model in logistic regression with dimension u.}
\usage{
logit.env(X, Y, u, asy = TRUE, init = NULL)
}
\arguments{
  \item{X}{Predictors. An n by p matrix, p is the number of predictors and n is number of observations.  The predictors must be continuous variables.}
  \item{Y}{Response. An n by 1 matrix. The univariate response must be binary.}
  \item{u}{Dimension of the envelope. An integer between 0 and p.}
  \item{asy}{Flag for computing the asymptotic variance of the envelope estimator.  The default is \code{TRUE}. When p and r are large, computing the asymptotic variance can take much time and memory.  If only the envelope estimators are needed, the flag can be set to \code{asy = FALSE}.}
  \item{init}{The user-specified value of Gamma for the envelope subspace in logistic regression. An p by u matrix. The default is the one generated by function logit.envMU.}
}
\details{
 This function fits the envelope model in logistic regression, \deqn{
 Y = exp(\mu + \beta' X) / (1 + exp(\mu + \beta' X)), \Sigma_{X}=\Gamma\Omega\Gamma'+\Gamma_{0}\Omega_{0}\Gamma'_{0}
}
using the maximum likelihood estimation.  When the dimension of the envelope is between 1 and p-1, the starting value and blockwise coordinate descent algorithm in Cook et al. (2016) is implemented.  This model works the best when X is multivariate normal.
}
\value{The output is a list that contains the following components:
\item{beta}{The envelope estimator of the canonical parameter.} 
\item{SigmaX}{The envelope estimator of the covariance matrix of X.}
\item{Gamma}{An orthonormal basis of the envelope subspace.}
\item{Gamma0}{An orthonormal basis of the complement of the envelope subspace.}
\item{eta}{The estimated beta of the canonical parameter with respect to Gamma.}
\item{Omega}{The coordinates of SigmaX with respect to Gamma.}
\item{Omega0}{The coordinates of SigmaX with respect to Gamma0.}
\item{mu}{The estimated intercept of the canonical parameter.}
\item{loglik}{The maximized log likelihood function.}
\item{covMatrix}{The asymptotic covariance of vec(beta). The covariance matrix returned are asymptotic.  For the actual standard errors, multiply by 1 / n.}
\item{asySE}{The asymptotic standard error for elements in beta under the envelope model.  The standard errors returned are asymptotic, for actual standard errors, multiply by 1 / sqrt(n).}
\item{ratio}{The asymptotic standard error ratio of the standard multivariate linear regression estimator over the envelope estimator, for each element in beta.}
\item{n}{The number of observations in the data.}
}
\references{
Cook, R. D., Zhang, X. (2015). Foundations for Envelope Models and Methods. Journal of the American Statistical Association 110, 599 - 611.

Cook, R. D., Forzani, L. and Su, Z. (2016) A Note on Fast Envelope Estimation. Journal of Multivariate Analysis. 150, 42-54.
}

\examples{
data(horseshoecrab)
X1 <- as.numeric(horseshoecrab[ , 1] == 2)
X2 <- as.numeric(horseshoecrab[ , 1] == 3)
X3 <- as.numeric(horseshoecrab[ , 1] == 4)
X4 <- as.numeric(horseshoecrab[ , 2] == 2)
X5 <- as.numeric(horseshoecrab[ , 2] == 3)
X6 <- horseshoecrab[ , 3]
X7 <- horseshoecrab[ , 5]
X <- cbind(X1, X2, X3, X4, X5, X6, X7)
Y <- as.numeric(ifelse(horseshoecrab[ , 4] > 0, 1, 0))

\dontrun{u <- u.logit.env(X, Y)}
\dontrun{u}

\dontrun{m <- logit.env(X, Y, 1)}
\dontrun{m$beta}
}

