% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Electoral_index.R
\name{Sainte_Lague}
\alias{Sainte_Lague}
\title{Sainte-Lague index of disproportionality (SL)}
\usage{
Sainte_Lague(votes, seats)
}
\arguments{
\item{votes}{It is a vector of integers, containing the votes of all the candidates.}

\item{seats}{It is a vector of integers, containing the seats obtained by each of the candidates.}
}
\value{
Returns the value obtained for the index
}
\description{
This index is designed to study the disproportionality of those electoral systems that use
the procedure of distribution of seats that has the same name (Sainte-Lague method). It should be noted
that this indicator takes into account the relative difference between the seats-votes of each party,
as well as that of the system as a whole. The formula used for its calculation is as follows:
\deqn{SL=\sqrt{\sum\frac{(E_{i}-V_{i})^{2}}{V_{i}}}}{SL =sqrt(sum((Vi-Ei)^2*(1/Vi)) }
for \eqn{i =  1, 2, \ldots,n vi>0}
}
\examples{

Sainte_Lague(c(3947,3189,1971,466,345,82),c(184,99,44,10,1,0))

}
