% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilidades.R
\name{InjusticiaM_desagregada}
\alias{InjusticiaM_desagregada}
\title{Utilities. Disaggregated Mathematical Injustice Calculation}
\usage{
InjusticiaM_desagregada(Ano, Mes, Ruta, Auto = TRUE, d_votos, d_escanos)
}
\arguments{
\item{Ano}{(Mandatory if Auto=TRUE)  It is the value of the year of the data
to be downloaded. This parameter can be numeric or character (better numeric).}

\item{Mes}{(Mandatory if Auto=TRUE) This is the month in which the election was
held. It must be a character with two digits, i.e. "04" is valid but "4" is not.}

\item{Ruta}{(Mandatory if Auto=TRUE) A path to the local hard disk where the data
from the Ministry of the Interior will be saved must be indicated. Once the download
is completed, the downloaded file will be automatically deleted.}

\item{Auto}{Its default value is TRUE and indicates that the procedure is automatic,
with another value the non-automatic process will be executed.}

\item{d_votos}{(Mandatory if Auto != TRUE). It is a data.frame with the first
column containing the name of the region, and then a column for each party
to be evaluated, which will contain the votes obtained in each region
under study.}

\item{d_escanos}{(Mandatory if Auto != TRUE).It is a data.frame with the first
column containing the name of the region, and then a column for each party to
be evaluated, which will contain the seats obtained in each region covered.}
}
\value{
The result is a list with 53 elements (for the automatic procedure), so
that each element is a matrix containing the data of the calculated mathematical
injustice. The 'names' in this list are those of Spanish provinces, or the
expression 'Total' if they are the data of all Spain.
When the procedure is not automatic, a list is also obtained containing a
number of elements equal to the number of regions provided plus one, as there
is an element called 'Total' which refers to all the territories provided as a whole.
}
\description{
The function of this same package called 'InjusticeM()',
allows to obtain the mathematical injustice for the dataset that is going
going to be used for the study. However, if we want to obtain the mathematical injustice for
different geographical areas, a significant effort and time is required
to prepare and execute the data. With this function, this process is
greatly expedited, if what we want to evaluate are results to the
Congress of Deputies in Spain (or its counterpart in other countries),
since thanks to this function, the information from the Ministry of
Interior can be automatically extracted and processed directly for
each province and national data, and the result is returned in a
list() type object, where each element corresponds to the result
obtained for each province or the total for the whole nation under study.

Likewise, if you have another type of election, you can use the parameter
Auto=FALSE, and two data.frame will be provided with the characteristics
that will be indicated later. In this way the mathematical injustices
will be calculated for each region that is indicated in those data.frames
}
\section{Utilities}{
NA
}

\examples{
f<-InjusticiaM_desagregada(2019,"04","F:/") # Aggregated mode

da1 <- data.frame( # Contains the votes
   Reg=c("Alava","Albacete","Madrid","Barcelona","Valladolid"),
     PSOE=c(400,300,0,50,25),
     PP=c(300,200,10,150,2),
     Cs=c(400,0,3,300,45),
     Uno=c(465,23,341,263,0))

da2 <- data.frame( # Contains the seats
     Reg=c("Alava","Albacete","Madrid","Barcelona","Valladolid"),
     PSOE=c(4,3,0,0,0),
     PP=c(2,3,0,1,0),
     Cs=c(4,0,0,2,1),
      Uno=c(3,0,3,2,0))

f2<- InjusticiaM_desagregada(Auto=FALSE,d_votos=da1,d_escanos = da2) #No agregegado
}
