% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Leer_Datos.R
\name{Desagregados_Mesa_Mir}
\alias{Desagregados_Mesa_Mir}
\title{Download. Disaggregated data at polling station level obtained from the MIR (Spanish Ministry of Home Office)}
\usage{
Desagregados_Mesa_Mir(Ano, Mes, Tipo, Ruta, Borrar = TRUE)
}
\arguments{
\item{Ano}{The election year in four-digit format (YYYY). Can be numeric or text.}

\item{Mes}{The election month. It has to be of character format. For example "06", corresponding to June.}

\item{Tipo}{The type of elections to which the data to be downloaded correspond: Congress (you must pass to the function the word "Congreso") or European (you must pass to the function the word "Europeas").}

\item{Ruta}{It is the local path from your computer where the zip files from the Spanish Ministry of Home Office (MIR) will be dowloaded.}

\item{Borrar}{It is a Boolean variable that indicates whether or not the downloaded files are deleted after creating the data.frame in R.}
}
\value{
Object of type 'tbl_df' with the data at polling station level.
}
\description{
This function serves to download the data in Excel format at polling station
level and then uploads a data.frame with that information into R. Note: The
returned fields are all of character format, so if you need to perform numeric
operations, you will have to convert the required fields to numeric.
}
\examples{

c2<-Desagregados_Mesa_Mir(2019,"04",Tipo = "Congreso", Ruta = "F:/",Borrar = TRUE)


}
