% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Leer_Datos.R
\name{Agregado_Mun_MIR}
\alias{Agregado_Mun_MIR}
\title{Download.  Aggregated data at the municipal level obtained from the MIR (Spanish Ministry of Home Office)}
\usage{
Agregado_Mun_MIR(Ano, Mes, Tipo, Ruta, Borrar = TRUE)
}
\arguments{
\item{Ano}{The election year in four-digit format (YYYY). Can be numeric or text.}

\item{Mes}{The election month. It has to be of character format. For example "06", corresponding to June.}

\item{Tipo}{The type of elections to which the data to be downloaded correspond: Congress (you must pass to the function the word "Congreso") or European (you must pass to the function the word "Europeas").}

\item{Ruta}{It is the local path from your computer where the zip files from the Spanish Ministry of Home Office (MIR) will be dowloaded.}

\item{Borrar}{It is a Boolean variable that indicates whether or not the downloaded files are deleted after creating the data.frame in R.}
}
\value{
Object of type 'tbl_df' with the data at municipal level.
}
\description{
This function serves to download the data in Excel format at the municipal level and
creates a data.frame in your R environment with that information. Note: The fields returned are all of character type,
so if you need to perform operations with them, you will have to convert the necessary fields to numeric.
}
\examples{
c<-Agregado_Mun_MIR(1989,"06",Tipo = "Europeas","F:/")


}
