% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global.test.R
\name{global.test}
\alias{global.test}
\title{Global Statistic for Two-Sided Tests}
\usage{
global.test(X, FUN, record = c(FU = 1, FL = 1, BU = 1, BL = 1), B = 1000, ...)
}
\arguments{
\item{X}{A numeric vector, matrix (or data frame).}

\item{FUN}{One of the functions whose statistic is going to be used. One of
\code{\link{p.chisq.test}}, \code{\link{p.regression.test}}, 
\code{\link{lr.test}} or \code{\link{score.test}}.}

\item{record}{Logical vector. Vector with four elements indicating if 
forward upper, forward lower, backward upper and backward lower are going
to be shown, respectively. Logical values or 0,1 values are accepted.}

\item{B}{An integer specifying the number of replicates used in the 
Monte Carlo approach.}

\item{...}{Further arguments in the \code{FUN} function.}
}
\value{
A list of class \code{"htest"}  with the following elements:
  \item{statistic}{Value of the  statistic.}
  \item{p.value}{Simulated p-value.}
  \item{method}{A character string indicating the type of test.}
  \item{data.name}{A character string giving the name of the data.}
}
\description{
Performs a more powerful generalisation of the 
  two-sided tests in this package by means of the sum of the statistics of 
  upper and lower records in the forward and backward directions to study 
  the hypothesis of the classical record model (i.e., of IID continuous 
  RVs). The tests considered are the chi-square goodness-of-fit test
  \code{\link{p.chisq.test}}, the regression test 
  \code{\link{p.regression.test}},
  the likelihood-ratio test \code{\link{lr.test}}, and the score test
  \code{\link{score.test}}.
}
\details{
The statistics, say \eqn{X}, of the tests \code{\link{p.chisq.test}},
  \code{\link{p.regression.test}}, \code{\link{lr.test}} or
  \code{\link{score.test}} applied to the series of the forward upper, 
  forward lower, backward upper and backward lower records are summed to 
  develop a more powerful statistic:
  \deqn{X^{(FU)} + X^{(FL)} + X^{(BU)} + X^{(BL)}.}
  Other sums of statistics are allowed.
  
  The distribution of this global statistics is unknown, 
  but the p-value can be estimated with Monte Carlo simulations
}
\examples{
# not run because the simulations take a while if B > 1000
## global statistic with 4 types of record for p.chisq.test
#global.test(ZaragozaSeries, FUN = p.chisq.test)
## global statistic with 4 types of record for p.regression.test
#global.test(ZaragozaSeries, FUN = p.regression.test)
## global statistic with 4 types of record for score.test with restricted alternative
#global.test(ZaragozaSeries, FUN = score.test, probabilities = "equal")
## global statistic with 4 types of record for lr.test with restricted alternative
#global.test(ZaragozaSeries, FUN = lr.test, probabilities = "equal")
## global statistic with 2 types of 'almost' independent records for lr.test
#global.test(ZaragozaSeries, FUN = lr.test, record = c(1,0,0,1), probabilities = "different")

}
\seealso{
\code{\link{p.chisq.test}}, \code{\link{p.regression.test}}, 
  \code{\link{lr.test}}, \code{\link{score.test}}
}
\author{
Jorge Castillo-Mateo
}
