% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/negexp.like.R
\name{negexp.like}
\alias{negexp.like}
\title{negexp.like - Negative exponential likelihood}
\usage{
negexp.like(a, dist, covars)
}
\arguments{
\item{a}{A vector or matrix of covariate 
and expansion term 
coefficients. Dimension is $k$ X $p$, where 
$k$ (i.e., \code{nrow(a)}) is the number of coefficient
vectors to evaluate (cases) and $p$ (i.e., \code{ncol(a)})
is the number of covariate and expansion 
coefficients in the likelihood. If \code{a} is a 
dimensionless vector, it is interpreted to be a 
single row with $k$ = 1. 
Covariate coefficients in \code{a} are the first 
$q$ values ($q$ <= $p$), and must be on a log scale.}

\item{dist}{A numeric vector of length $n$ or 
a single-column matrix (dimension $n$X1) containing 
detection distances at which to evaluate the likelihood.}

\item{covars}{A numeric vector of length $q$ or 
matrix of dimension $n$X$q$ containing covariate values 
associated with distances in argument \code{d}}
}
\value{
A list containing the following two components:
\itemize{
  \item \bold{L.unscaled}: A matrix of size $n$X$k$X$b$ 
   containing likelihood values evaluated at 
   distances in \code{dist}.
    Each row is associated with 
   a single distance, and each column is associated with 
   a single case (row of \code{a}).  This matrix is  
   "unscaled" because the underlying likelihood does 
   not integrate to one. Values in \code{L.unscaled} 
   are always greater than or equal to zero.
   
 \item \bold{params}: A $n$X$k$X$b$ array of the 
 likelihood's (canonical) parameters, First page contains 
 parameter values related to covariates (i.e., $s = exp(x'a)$),
 while subsequent pages contain other parameters. 
 $b$ = 1 for halfnorm, negexp; $b$ = 2 for hazrate and 
 others.
 Rows correspond to distances in \code{dist}. Columns 
 correspond to rows from argument \code{a}. 
}
}
\description{
Computes the negative exponential distance function.
}
\details{
The negative exponential likelihood is 
\deqn{f(x|a) = \exp(-ax)}{f(x|a) = exp( -a*x )} where \eqn{a} is the 
slope parameter.
}
\examples{
d <- seq(0, 100, length=100)
covs <- matrix(1,length(d),1)
negexp.like(log(0.01), d, covs)

# Changing slope parameter
plot(d, negexp.like(log(0.1), d, covs)$L.unscaled, type="l", col="red")
lines(d, negexp.like(log(0.05), d, covs)$L.unscaled, col="blue")

}
\seealso{
\code{\link{dfuncEstim}},
         \code{\link{hazrate.like}},
         \code{\link{negexp.like}}
}
