% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lines.dfunc.R
\name{lines.dfunc}
\alias{lines.dfunc}
\title{lines.dfunc - Line plotting method for distance functions}
\usage{
\method{lines}{dfunc}(x, newdata = NULL, prob = NULL, ...)
}
\arguments{
\item{x}{An estimated detection function object, normally 
produced by calling \code{\link{dfuncEstim}}.}

\item{newdata}{A data frame containing new values of 
the covariates at which to evaluate the distance functions. 
If \code{newdata}
is NULL, distance functions are evaluated at values of 
the observed covariates and results in one prediction 
per distance or transect (see parameter \code{type}). 
If \code{newdata} is not NULL and the model does not contains covariates, 
this routine returns one prediction for each row in \code{newdata}, but 
columns and values in \code{newdata} are ignored.}

\item{prob}{Logical scalar for whether to scale the distance function 
to be a density function (integrates to one). Default behavior is designed 
to be compatible with the plot method for distance functions 
(\code{\link{plot.dfunc}}). By default, line transect distance 
functions are not scaled to a density and integrate to the effective strip width. 
In contrast, point transects distance functions are scaled to be densities 
by default.}

\item{\dots}{Parameters passed to \code{lines.default} that control attributes like 
color, line width, line type, etc.}
}
\value{
A data frame containing the x and y coordinates of the 
plotted line(s) is returned invisibly.  X coordinates in the 
return are names \code{x}. Y coordinates in the return are named 
\code{y1, y2, ..., yn}, i.e., one column per returned 
distance function.
}
\description{
Line plot method for objects of class '\code{dfunc}' 
that adds distance functions to an existing plot.
}
\examples{
set.seed(87654)
x <- rnorm(1000, mean=0, sd=20)
x <- x[x >= 0]
x <- units::set_units(x, "mi")
Df <- data.frame(transectID = "A"
               , distance = x
                ) |> 
  dplyr::nest_by( transectID
               , .key = "detections") |> 
  dplyr::mutate(length = units::set_units(100,"km"))              
attr(Df, "detectionColumn") <- "detections"
attr(Df, "obsType") <- "single"
attr(Df, "transType") <- "line"
attr(Df,'effortColumn') <- "length"
is.RdistDf(Df)  # TRUE

dfunc <- Df |> dfuncEstim(distance ~ 1, likelihood="halfnorm")
plot(dfunc, nbins = 40, col="lightgrey", border=NA, vertLines=FALSE)
lines(dfunc, col="grey30", lwd=15)
lines(dfunc, col="grey90", lwd=5, lty = 2)

# Multiple lines 
data(sparrowDfuncObserver)
obsLevs <- levels(sparrowDfuncObserver$data$observer)
plot(sparrowDfuncObserver
   , vertLines = FALSE
   , lty = 0
   , plotBars = FALSE
   , main="Detection by observer"
   , legend = FALSE)
y <- lines(sparrowDfuncObserver
   , newdata = data.frame(observer = obsLevs)
   , col = palette.colors(length(obsLevs))
   , lty = 1
   , lwd = 4)
head(y) # values returned, with distances as column


}
\seealso{
\code{\link{dfuncEstim}}, \code{\link{plot.dfunc}},
  \code{\link{print.abund}}
}
