% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concepts.R
\name{unique.SNOMEDconcept}
\alias{unique.SNOMEDconcept}
\title{Unique vector of SNOMED CT concepts}
\usage{
\method{unique}{SNOMEDconcept}(x, ...)
}
\arguments{
\item{x}{SNOMEDconcept vector}

\item{...}{other variables to pass on to the underlying 'unique' function}
}
\value{
SNOMEDconcept vector with duplicates removed
}
\description{
SNOMEDconcept is an S3 class for vectors of SNOMED concept IDs
as 64-bit integers. This function returns a vector containing only
unique SNOMEDconcept values.
}
\examples{
hf <- SNOMEDconcept('Heart failure', SNOMED = sampleSNOMED())
hf2 <- c(hf, hf)
unique(hf2)
}
\seealso{
Other SNOMEDconcept functions: 
\code{\link{as.data.frame.SNOMEDconcept}()},
\code{\link{c.SNOMEDconcept}()},
\code{\link{is.SNOMEDconcept}()},
\code{\link{print.SNOMEDconcept}()},
\code{\link{union.SNOMEDconcept}()}
}
\concept{SNOMEDconcept functions}
