% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/REFSET.R
\docType{data}
\name{SNOMED_REFSET}
\alias{SNOMED_REFSET}
\alias{REFSET}
\title{Sample refset table from SNOMED CT dictionary}
\format{
An object of class \code{"data.table"}
}
\usage{
data(REFSET)
}
\description{
A sample of the SNOMED CT refset table. This contains SNOMED CT
codelists that are used for partiular operational or clinical
purposes, and are curated by SNOMED CT. The id column of the
refset table is not included, in order to save space.
}
\details{
\describe{
  \item{moduleId}{ integer64: SNOMED CT core metadata concept, stating whether the refset is from the SNOMED CT core module or the UK extension.}
  \item{refsetId}{ integer64: SNOMED CT conceptId of the refset. These concepts have semantic type 'foundation metadata concept'} 
  \item{referencedComponentId}{ integer64: SNOMED CT conceptId of the member of the refset} 
  \item{effectiveTime}{ IDate: when the concept became active}
  \item{active}{ logical: whether this concept is currently active}
}
}
\examples{
# Load the dataset and show its properties
data('REFSET')
str(REFSET)

# This REFSET table is part of the sample SNOMED CT dictionary
# Hence this should show the same properties as above
str(sampleSNOMED()$REFSET)
}
\seealso{
Other sampleSNOMED: 
\code{\link{HISTORY}},
\code{\link{READMAPS}},
\code{\link{SNOMED_CONCEPT}},
\code{\link{SNOMED_DESCRIPTION}},
\code{\link{SNOMED_EXTENDEDMAP}},
\code{\link{SNOMED_RELATIONSHIP}},
\code{\link{SNOMED_SIMPLEMAP}},
\code{\link{sampleSNOMED}()}
}
\concept{sampleSNOMED}
\keyword{datasets}
