% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdindex.R
\name{rdindex}
\alias{rdindex}
\title{Get Rdatasets Index}
\usage{
rdindex()
}
\value{
A data frame containing all available datasets from Rdatasets with the following columns:
\itemize{
\item \code{Package}: Character. The name of the R package that contains the dataset
\item \code{Dataset}: Character. The name of the dataset
\item \code{Title}: Character. A descriptive title for the dataset
\item \code{Rows}: Integer. Number of rows in the dataset
\item \code{Cols}: Integer. Number of columns in the dataset
\item \code{n_binary}: Integer. Number of binary variables in the dataset
\item \code{n_character}: Integer. Number of character variables in the dataset
\item \code{n_factor}: Integer. Number of factor variables in the dataset
\item \code{n_logical}: Integer. Number of logical variables in the dataset
\item \code{n_numeric}: Integer. Number of numeric variables in the dataset
\item \code{CSV}: Character. URL to download the dataset in CSV format
\item \code{Doc}: Character. URL to the dataset's documentation
}
}
\description{
Downloads and returns the complete Rdatasets index as a data frame.
}
\section{Global Options}{

The following global options control package behavior:
\itemize{
\item \code{Rdatasets_cache}: Logical
\itemize{
\item Whether to cache downloaded data and index for faster subsequent access. Default: \code{TRUE}. Please keep this option TRUE as it makes repeated access faster and avoids overloading the Rdatasets server. Only set to FALSE if local memory is severely limited.
\item Ex: `options(Rdatasets_cache = TRUE)``
}
\item \code{Rdatasets_class}: String
\itemize{
\item Output class of the returned data. One of "data.frame" (default), "tibble", or "data.table". Default: \code{"data.frame"}. Requires the respective packages to be installed for "tibble" or "data.table" formats.
\item Ex: \code{options(Rdatasets_class = "tibble")}
}
\item \code{Rdataset_path}: String.
\itemize{
\item Base URL for the Rdatasets archive. Default: \code{"https://vincentarelbundock.github.io/Rdatasets/"}. Advanced users can set this to use a different mirror or local copy.
\item Ex: \code{options(Rdataset_path = "https://vincentarelbundock.github.io/Rdatasets/")}
}
}
}

\examples{
idx <- rdindex()
head(idx)
}
