% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{col_mut_info}
\alias{col_mut_info}
\title{Column-wise mutual information}
\usage{
col_mut_info(x, y, args = NULL)
}
\arguments{
\item{x}{Matrix or data frame of discrete values (integers). Rows contain samples and columns contain features/variables.}

\item{y}{Factor of class labels for the data samples. A response vector with one label for each row/component of \code{x}.}

\item{args}{\code{NULL} (default) or list of named arguments: \describe{
\item{method}{Integer indicating computation method: 0 = empirical, 1 = Miller-Madow,
2 = shrink, 3 = Schurmann-Grassberger.}
}}
}
\value{
An output is a single matrix with the same number of columns as X and 1 row.
}
\description{
Calculate mutual information for every column of a matrix or data frame. Only discrete values are allowed.
For better performance, data frame is preferred.
}
\note{
Change log:
\itemize{
\item{0.1.0 Xiurui Zhu - Initiate the function.}
}
}
\examples{
if (require("MASS", quietly = TRUE) == TRUE) {
  data(cats)
  print(res_cpp <- col_mut_info(round(cats[, 2L:3L]), cats[, 1L]))
  # Validate with caTools::colAUC()
  if ((require("infotheo", quietly = TRUE) == TRUE) &&
      (require("magrittr", quietly = TRUE) == TRUE)) {
    print(res_r <- sapply(round(cats[, 2L:3L]), infotheo::mutinformation, cats[, 1L]) \%>\%
            {matrix(., nrow = 1L, dimnames = list(NULL, names(.)))})
    identical(res_cpp, res_r)
  }
}
}
\seealso{
\code{infotheo::mutinformation} for the original computation
of mutual information in \R (and also the computation methods).

\code{\link{col_mut_info_vec}} for the vectorized version.
}
