% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rankPCA.R
\name{rankPCA}
\alias{rankPCA}
\title{Rank Principal Component Analysis for Mixed Data Types}
\usage{
rankPCA(data, range_cat_var, range_continuous_var, threshold)
}
\arguments{
\item{data}{data to be analyzed.}

\item{range_cat_var}{Range of categorical variables.}

\item{range_continuous_var}{Range of continuous variables.}

\item{threshold}{Threshold for cumulative variance explained.}
}
\value{
A list containing PCA results and composite index.
}
\description{
This function performs Principal Component Analysis (PCA) on datasets containing both categorical and continuous variables. It facilitates data preprocessing, encoding of categorical variables, and computes PCA to determine the optimal number of principal components based on a specified variance threshold. The function also computes composite indices for ranking observations.
}
\examples{
# Create a sample dataset
set.seed(123)
sample_data <- data.frame(
  Category1 = sample(c("A", "B", "C"), 100, replace = TRUE),
  Category2 = sample(c("X", "Y", "Z"), 100, replace = TRUE),
  Category3 = sample(c("M", "N", "O"), 100, replace = TRUE),
  Continuous1 = rnorm(100),
  Continuous2 = runif(100, min = 0, max = 100),
  Continuous3 = rnorm(100, mean = 50, sd = 10),
  Continuous4 = rpois(100, lambda = 5),
  Continuous5 = rbinom(100, size = 10, prob = 0.5)
)
result <- rankPCA(data = sample_data,
                  range_cat_var = 1:3,
                  range_continuous_var = 4:8,
                  threshold = 80)

# Access the results
eigenvalues_pca <- result$eigenvalues_pca
pca_max_dim <- result$pca_max_dim
coordinates <- result$coordinates
eigenvalues <- result$eigenvalues
weighted_coordinates <- result$weighted_coordinates
weighted_sums <- result$weighted_sums
composite_index <- result$composite_index
loading_vectors <- result$loading_vectors
}
\references{
Garai, S., & Paul, R. K. (2023). Development of MCS based-ensemble models using CEEMDAN decomposition and machine intelligence. Intelligent Systems with Applications, 18, 200202, https://doi.org/10.1016/j.iswa.2023.200202.
}
