% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fur.R
\name{fur}
\alias{fur}
\title{FUR}
\usage{
fur(
  input_rkgs,
  subit_len_list,
  search_radius,
  seed_rkg = c(),
  objNames = c(),
  wt = c()
)
}
\arguments{
\item{input_rkgs}{a \code{n} by \code{k} matrix of \code{k} rankings of \code{n}
objects, where each column is a complete ranking.}

\item{subit_len_list}{a vector containing positive integer(s) for the subiteration
lengths to \emph{Subiterative Convergence}. Recommended values are between 2 and 8.
Smaller subiteration lengths result in shorter run-time.}

\item{search_radius}{a positive integer for the maximum change in the rank of each
object in the \emph{Greedy Algorithm}. The default value
of \code{0} considers all possible rank changes for each object. It is
recommended to use a search radius of less than or equal to \eqn{\min(30, \lfloor \mbox{n}/2 \rfloor)}{min(30, floor(n/2))}.}

\item{seed_rkg}{a vector of length \code{n} with an initial ranking to begin FUR. If
the default value of an empty vector is used, then the \code{mean seed ranking} is adopted
as the initial ranking to FUR.}

\item{objNames}{a \code{n}-length vector containing object names. An optional
parameter.}

\item{wt}{a \code{k}-length vector containing weights for each
judge or attribute. An optional parameter.}
}
\value{
A list containing the consensus ranking (expressed as ordering), total Kemeny distance, and average
tau correlation coefficient corresponding to the consensus ranking.
}
\description{
\emph{FUR} is a heuristic algorithm to obtain a consensus ranking.
It contains three branches -- Fixed, Update, and Range -- that use
\emph{Subiterative Convergence} and \emph{Greedy Algorithm} iteratively.
See `Details' for more information on each branch.
}
\details{
The Fixed branch applies \emph{Subiterative Convergence} using one subiteration
length from \code{subit_len_list} at a time.

The Update branch executes \emph{Subiterative Convergence} using the first
subiteration length in \code{subit_len_list}, and then uses its output in the
next call to \emph{Subiterative Convergence} with the next subiteration length in the list.
This process repeats until \code{subit_len_list} is exhausted.

The Range branch calls \emph{Subiterative Convergence} on all subiteration lengths in
\code{subit_len_list} and only retains the best ranking among these separate calls.

The output from the \emph{Subiterative Convergence} calls are fed into the \emph{Greedy Algorithm}
as its seed ranking, and the FUR algorithm is terminated when the input to the
\emph{Greedy Algorithm} converges to the output and all branches have been executed at
least once.
}
\examples{
## One subiteration length
input_rkgs <- matrix(c(3, 2, 5, 4, 1, 2, 3, 1, 5, 4, 5, 1, 3, 4, 2, 1, 2, 4, 5, 3),
    byrow = FALSE, ncol = 4)
subit_len_list <- 2
search_radius <- 1
fur(input_rkgs, subit_len_list, search_radius) # Determined the consensus ranking, total Kemeny
                                              # distance, and average tau correlation coefficient

## Multiple subiteration lengths
input_rkgs <- matrix(c(3, 2, 5, 4, 1, 2, 3, 1, 5, 4, 5, 1, 3, 4, 2, 1, 2, 4, 5, 3),
    byrow = FALSE, ncol = 4)
subit_len_list <- c(2,3)
search_radius <- 1
fur(input_rkgs, subit_len_list, search_radius)

## Five input rankings with five objects 
## 2nd ranking == 3rd ranking, so if a third object is weighted as zero,
## we should get the same answer as the first examples
input_rkgs <- matrix(c(3, 2, 5, 4, 1, 2, 3, 1, 5, 4, 2, 3, 1, 5, 4, 5, 1, 3, 4, 2, 1, 
                       2, 4, 5, 3),byrow = FALSE, ncol = 5)
## Multiple subiteration lengths
wt = c(1,1,0,1,1)
subit_len_list <- c(2,3)
search_radius <- 1
fur(input_rkgs, subit_len_list, search_radius,wt=wt)

## Using five input rankings with five objects with prepare_data to 
## automatically prepare the weight vector
input_rkgs <- matrix(c(3, 2, 5, 4, 1, 2, 3, 1, 5, 4, 2, 3, 1, 5, 4, 5, 1, 3, 4, 2, 1, 
                       2, 4, 5, 3),byrow = FALSE, ncol = 5)
out = prepare_data(input_rkgs) 
input_rkgs = out$input_rkgs
wt = out$wt
subit_len_list <- c(2,3)
search_radius <- 1
fur(input_rkgs, subit_len_list, search_radius,wt=wt)

## Included dataset of 15 input rankings of 50 objects
data(data50x15)
input_rkgs <- as.matrix(data50x15[, -1])
subit_len_list <- c(2, 3)
search_radius <- 1
fur(input_rkgs, subit_len_list, search_radius)

}
\references{
Badal, P. S., & Das, A. (2018). Efficient algorithms using subiterative
convergence for Kemeny ranking problem. Computers & Operations Research, 98, 198-210.
\doi{10.1016/j.cor.2018.06.007}
}
\seealso{
\code{\link{mean_seed}}, \code{\link{subit_convergence}}, \code{\link{rap_greedy_alg}}, \code{\link{sigfur}}
}
