% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freedom_functions_1.R
\name{n.hypergeo}
\alias{n.hypergeo}
\title{Hypergeometric sample size}
\usage{
n.hypergeo(sep, N, d, se = 1)
}
\arguments{
\item{sep}{desired population sensitivity (scalar or vector)}

\item{N}{population size (scalar or vector of same length as sep)}

\item{d}{expected number of infected units in population, = design prevalence*N
rounded to next integer (scalar or vector of same length as sep)}

\item{se}{unit sensitivity, default = 1 (scalar or vector of same length as sep)}
}
\value{
vector of sample sizes, NA if n>N
}
\description{
Calculates sample size for demonstrating freedom or
  detecting disease using hypergeometric approximation and assuming
  imperfect test sensitivity, perfect test specificity and
  representative sampling
}
\examples{
# examples for n.hypergeo - checked
n.hypergeo(0.95, N=100, d=1, se = 0.95)
n.hypergeo(sep=0.95, N=c(100, 200, 500, 1000, 10000), d=ceiling(0.01*c(100, 200, 500, 1000, 10000)))
n.hypergeo(c(0.5, 0.8, 0.9, 0.95), N=100, d=5)
n.hypergeo(0.95, N=80, d=c(1, 2, 5, 10))
n.hypergeo(0.95, N=80, d=c(1, 2, 5, 10), se = 0.8)
}
\keyword{methods}
