% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freedom_functions_2.R
\name{n.freecalc}
\alias{n.freecalc}
\title{Freecalc sample size for a finite population and specified cut-point number of positives}
\usage{
n.freecalc(N, sep = 0.95, c = 1, se, sp = 1, pstar, minSpH = 0.95)
}
\arguments{
\item{N}{population size}

\item{sep}{target population sensitivity}

\item{c}{The cut-point number of positives to classify a cluster
as positive, default=1, if positives < c result is negative, >= c is positive}

\item{se}{test unit sensitivity}

\item{sp}{test unit specificity, default=1}

\item{pstar}{design prevalence as a proportion or integer (number of infected units)}

\item{minSpH}{minimium desired population specificity}
}
\value{
a list of 2 elements, a dataframe with 1 row and six columns for
  the recommended sample size and corresponding values for population sensitivity (SeP),
  population specificity (SpP), N, c and pstar
  and a dataframe of n rows with SeP and SpP values for each value of n up to the recommended value
}
\description{
Calculates sample size required for a specified population sensitivity,
for a given population size, cut-point number of positives and other parameters, 
using Freecalc algorithm. All paramaters must be scalars
}
\examples{
# examples for n.freecalc
n.freecalc(65,0.95,c=1,se=0.95,sp=0.99,pstar=0.05, minSpH=0.9)[[1]]
n.freecalc(65,0.95,c=2,se=0.95,sp=0.99,pstar=0.05, minSpH=0.9)[[1]]
n.freecalc(65,0.95,c=3,se=0.95,sp=0.99,pstar=0.05, minSpH=0.9)
}
\keyword{methods}
