% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freedom_functions_1.R
\name{n.2stage}
\alias{n.2stage}
\title{2-stage freedom sample size}
\usage{
n.2stage(H = NA, N = NA, sep.sys = 0.95, sep.c, pstar.c, pstar.u,
  se = 1)
}
\arguments{
\item{H}{population size = number of clusters or NA if not known, default = NA}

\item{N}{population sizes for clusters, default = NA, scalar or
vector of population sizes for clusters}

\item{sep.sys}{desired population sensitivity (scalar)}

\item{sep.c}{desired cluster-level sensitivity (scalar)}

\item{pstar.c}{specified cluster-level design prevalence as
proportion or integer (scalar)}

\item{pstar.u}{specified population-level design prevalence as
proportion or integer (scalar)}

\item{se}{unit sensitivity (scalar)}
}
\value{
a list of 2 elements, the number of clusters to sample and a vector of
  sample sizes per cluster
}
\description{
Calculates sample sizes for a 2-stage representative survey
  (sampling of clusters and units within clusters) for disease freedom or detection,
  assuming imperfect test sensitivity, perfect test specificity and representative sampling
}
\examples{
# examples of n.2stage - checked
n.2stage(NA, NA, 0.95, 0.5, 0.01, 0.1, 0.95)
n.2stage(500, NA, 0.95, 0.5, 10, 0.1, 0.95)
n.2stage(1000, c(50, 100, 200, 500, 1000, 5000, NA), 0.95, 0.5, 0.01, 0.05, 0.8)
n.2stage(1000, c(50, 100, 200, 500, 1000, 5000, NA), 0.95, 0.5, 0.01, 1, 0.8)
n.2stage(1000, c(50, 100, 200, 500, 1000, 5000, NA), 0.9, 0.95, 1, 0.1, 0.8)
}
\keyword{methods}
