% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teststat_MRSS.R
\name{teststat_MRSS}
\alias{teststat_MRSS}
\title{Median Ranked Set Sampling Test}
\usage{
teststat_MRSS(
  x1,
  x2,
  alpha = 0.05,
  alternative = "two-tailed",
  tn = 2000,
  table = TRUE
)
}
\arguments{
\item{x1}{A (non-empty) numeric matrix (m1xr1) of median ranked set sample for Group 1 with set size m1 and cycle size r1.}

\item{x2}{A (non-empty) numeric matrix (m2xr2) of median ranked set sample for Group 2 with set size m2 and cycle size r2.}

\item{alpha}{A scalar value of the significance level for hypothesis testing used in the table. Default is 0.05.}

\item{alternative}{A character string specifying the alternative hypothesis, must be one of "two-sided", "right" or "left". Can be abbreviated. Default is "two-sided".}

\item{tn}{A scalar value of the number of repetitions of Monte Carlo simulation. Default is 2000.}

\item{table}{A logical value that shows table gives the results of the hypothesis test are printed out. Default is TRUE.}
}
\value{
If table is TRUE the hypothesis test results table includes sample sizes, test statistics, p values and test results are printed out.
}
\description{
This function tests for the difference of two population means using ranked set sampling given in Özdemir, Ebegil and Gökpınar (2019).
}
\examples{
x1=matrix(c(1,2.3, 3.4,4.5,5.6,4 ),nrow=3)
x2=matrix(c(2,3.2, 4.2,6.5,4.6,6 ),nrow=3)
teststat_MRSS(x1,x2,tn=1000)
}
\references{
MacEachern, S. N., Öztürk, Ö., Wolfe, A. D. (2002). A new ranked set sample estimator of variance. Journal of the Royal Statistical Society: Series B., 64, Part 2 177–188.

Özturk, Ö., Balakrishnan N (2009) Exact two-sample nonparametric test for quantile difference between two populations based on ranked set samples. Ann Inst Stat Math 61(1):235–249

Özdemir, Y. A., Ebegil, M., & Gökpinar, F. (2017). A test statistic based on ranked set sampling for two normal means. Communications in Statistics-Simulation and Computation, 46(10), 8077-8085.

Özdemir, Y. A., Ebegil, M., & Gökpinar, F. (2019). A test statistic for two normal means with median ranked set sampling. Iranian Journal of Science and Technology, Transactions A: Science, 43(3), 1109-1126.
}
\seealso{
\code{\link[RSStest]{datagen_MRSS}}, \code{\link[RSStest]{datagen_RSS}},
\code{\link[RSStest]{teststat_RSS}}
}
