% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imperfectMRSS.R
\name{imperfectMRSS}
\alias{imperfectMRSS}
\title{Imperfect Median Ranked Set Sampling Data Generation from Finite Population}
\usage{
imperfectMRSS(df, cat, catname, aux, var, r1, r2, m1, m2)
}
\arguments{
\item{df}{: dataframe of the finite population}

\item{cat}{:  the indicator variable that shows the group of units}

\item{catname}{:  the group names}

\item{aux}{: auxilary variable}

\item{var}{: variable of interest}

\item{r1}{: Cycle size of first group}

\item{r2}{: Cycle size of second group}

\item{m1}{: Set size of first group}

\item{m2}{: Set size of second group}
}
\value{
two median ranked set sample matrix with sizes r1xm1 and r2xm2 from finite population. Each row indicates a cycle.
}
\description{
This function chooses Median Ranked Set samples from specific finite population using
auxiliary variable with cycle sizes r1 and r2 and set sizes m1 and m2.
}
\examples{
data(otolith)
imperfectMRSS(otolith,"sex",c("F","M"),"fish.length","age",3,3,4,3)
 
}
\references{
MacEachern, S. N., Öztürk, Ö., Wolfe, A. D. (2002). A new ranked set sample estimator of variance. Journal of the Royal Statistical Society: Series B., 64, Part 2 177–188.

Özturk, Ö., Balakrishnan N (2009) Exact two-sample nonparametric test for quantile difference between two populations based on ranked set samples. Ann Inst Stat Math 61(1):235–249

Özdemir, Y. A., Ebegil, M., & Gökpinar, F. (2017). A test statistic based on ranked set sampling for two normal means. Communications in Statistics-Simulation and Computation, 46(10), 8077-8085.

Özdemir, Y. A., Ebegil, M., & Gökpinar, F. (2019). A test statistic for two normal means with median ranked set sampling. Iranian Journal of Science and Technology, Transactions A: Science, 43(3), 1109-1126.
}
\seealso{
\code{\link[RSStest]{datagen_RSS}},  \code{\link[RSStest]{teststat_RSS}}
\code{\link[RSStest]{teststat_MRSS}},\code{\link[RSStest]{imperfectRSS}}
}
