% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sym.quantiles.PCA.plot.r
\name{sym.quantiles.PCA.plot}
\alias{sym.quantiles.PCA.plot}
\title{sym.quantiles.PCA.plot}
\usage{
sym.quantiles.PCA.plot(
  histogram.PCA.r,
  concept.names,
  var.names,
  Title,
  axes.x.label,
  axes.y.label,
  label.name
)
}
\arguments{
\item{histogram.PCA.r}{A quantil matrix}

\item{concept.names}{Concept Name}

\item{var.names}{Variables to plot}

\item{Title}{Plot title}

\item{axes.x.label}{Label of axis X}

\item{axes.y.label}{Label of axis Y}

\item{label.name}{Concept Variable}
}
\value{
3D plot
}
\description{
sym.quantiles.PCA.plot
}
\examples{
\dontrun{
data("hardwoodBrito")
Hardwood.histogram<-hardwoodBrito
Hardwood.cols<-colnames(Hardwood.histogram)
Hardwood.names<-row.names(Hardwood.histogram)
 M<-length(Hardwood.cols)
 N<-length(Hardwood.names)
 BIN.Matrix<-matrix(rep(3,N*M),nrow = N)
pca.hist<-sym.histogram.pca(Hardwood.histogram,BIN.Matrix)
Hardwood.quantiles.PCA<-quantiles.RSDA(pca.hist$sym.hist.matrix.PCA,3)
label.name<-"Hard Wood"
Title<-"First Principal Plane"
axes.x.label<- "PC 1 (84.83\%)"
axes.y.label<- "PC 2 (9.70\%)"
concept.names<-c("ACER")
var.names<-c("PC.1","PC.2")
plot.3D.HW<-sym.quantiles.PCA.plot(Hardwood.quantiles.PCA,
                                     concept.names,
                                     var.names,
                                     Title,
                                     axes.x.label,
                                     axes.y.label,
                                     label.name)

plot.3D.HW
}
}
\author{
Jorge Arce Garro
}
