% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RSBJsonService.R
\name{RSBJsonService}
\alias{RSBJsonService}
\title{Generic Function to Handle R Requests from RSB JSON Applications}
\usage{
RSBJsonService(jsonString)
}
\arguments{
\item{jsonString}{character vector of length one containing the JSON string}
}
\value{
object of class \code{json} as returned by \code{\link[jsonlite]{toJSON}}
}
\description{
The function extracts relevant information from the JSON string
to dispatch to the appropriate R wrapper for that particular
application
}
\examples{
examplePath <- system.file("examples", "example.json", package = "RSBJson")
exampleCon <- file(description = examplePath, open = "rt")
exampleLines <- readLines(exampleCon)
close(exampleCon)
exampleString <- paste(exampleLines, collapse = "\n")
(string <- RSBJsonService(jsonString = exampleString))
}
