assertdf_cdt <- function(cmt) {
  assertDataFrame(
    cmt@parameters@df_cdt,
    min.rows = 1L,
    min.cols = 4L,
    .var.name = "df_cdt"
  )
  assertCharacter(
    names(cmt@parameters@df_cdt),
    min.chars = 1L,
    any.missing = FALSE,
    min.len = 4L,
    unique = TRUE,
    .var.name = "names(df_cdt)"
  )
  assertSubset(
    c("ID", "x", "y"),
    names(cmt@parameters@df_cdt),
    .var.name = "names(df_cdt)"
  )
  assertVector(
    cmt@parameters@df_cdt[["ID"]],
    strict = TRUE,
    any.missing = FALSE,
    min.len = 1L,
    unique = TRUE,
    .var.name = 'df_cdt[["ID"]]'
  )
  assertNumeric(
    cmt@parameters@df_cdt[["x"]],
    lower = xmin(cmt@helpers@ex_cmt),
    upper = xmax(cmt@helpers@ex_cmt),
    any.missing = FALSE,
    min.len = 1L,
    .var.name = 'df_cdt[["x"]]'
  )
  assertNumeric(
    cmt@parameters@df_cdt[["y"]],
    lower = ymin(cmt@helpers@ex_cmt),
    upper = ymax(cmt@helpers@ex_cmt),
    any.missing = FALSE,
    min.len = 1L,
    .var.name = 'df_cdt[["y"]]'
  )
}

assertCol <- function(cmt, col) {
  assertdf_cdt(cmt)
  assertChoice(col, setdiff(names(cmt@parameters@df_cdt), c("ID", "x", "y")))
  assertNumeric(
    cmt@parameters@df_cdt[[col]],
    lower = 0,
    finite = TRUE,
    all.missing = FALSE,
    min.len = 1L,
    .var.name = "df_cdt[[col]]"
  )
}
