% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_omdb_several_items.R
\name{get_omdb_several_items}
\alias{get_omdb_several_items}
\title{Get OMDB Several Items}
\usage{
get_omdb_several_items(omdb_ids, include_gif = TRUE,
  API_KEY = Sys.getenv("API_KEY"))
}
\arguments{
\item{omdb_ids}{Vector with the omdb_ids for selected movies/series. All the IDs must be the same type (movie or series).}

\item{include_gif}{If TRUE, the result includes a gif of the movies/series. Default: TRUE.}

\item{API_KEY}{OMBD Api Key. Default: Get the Api Key from system environment. Use Sys.setenv('API_KEY' = 'XXXXX'). More information in: http://www.omdbapi.com/apikey.aspx}
}
\value{
If include_gif is TRUE, returns a list with a tibble with the movie information and a gif of the films. If include_image is FALSE, only returns the tibble.
}
\description{
This function searches OMDB Movies/Series by ID.
}
\examples{
\dontrun{
get_omdb_several_items(odmb_ids = search_omdb_items('Titanic', include_gif = F) \%>\% .$imdb_id)
}
}
\author{
Alberto Almuiña
}
