% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_omdb_item_poster.R
\name{get_omdb_item_poster}
\alias{get_omdb_item_poster}
\title{Get OMDB Item Poster}
\usage{
get_omdb_item_poster(omdb_id, API_KEY = Sys.getenv("API_KEY"))
}
\arguments{
\item{omdb_id}{String with the omdb_id for a movie/series.}

\item{API_KEY}{OMBD Api Key. Default: Get the Api Key from system environment. Use Sys.setenv('API_KEY' = 'XXXXX'). More information in: http://www.omdbapi.com/apikey.aspx}
}
\value{
Return an image with the movie/series poster.
}
\description{
This function searches Item Poster.
}
\examples{
\dontrun{
get_omdb_item_poster(omdb_id = 'tt0120338')
}
}
\author{
Alberto Almuiña
}
