% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ODBCDriver.R
\docType{methods}
\name{dbConnect,ODBCDriver-method}
\alias{dbConnect,ODBCDriver-method}
\title{Connect/disconnect to a ODBC data source}
\usage{
\S4method{dbConnect}{ODBCDriver}(drv, dsn, user = NULL, password = NULL,
  ...)
}
\arguments{
\item{drv}{an object of class ODBCDriver}

\item{dsn}{Data source name you defined by ODBC data source administrator tool.}

\item{user}{User name to connect as.}

\item{password}{Password to be used if the DSN demands password authentication.}

\item{...}{Other parameters passed on to methods}
}
\description{
These methods are straight-forward implementations of the corresponding generic functions.
}
\examples{
\dontrun{
# Connect to a ODBC data source
con <- dbConnect(RODBCDBI::ODBC(), dsn="test")
# Always cleanup by disconnecting the database
#' dbDisconnect(con)
}
}

