% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROCSI.R
\name{ROCSI}
\alias{ROCSI}
\title{ROCSI}
\usage{
ROCSI(
  Dtrain,
  Dtest = NULL,
  yvar,
  xvars,
  trtvar,
  cvar = NULL,
  nfolds = 5,
  type = "binary"
)
}
\arguments{
\item{Dtrain}{data matrix for training dataset}

\item{Dtest}{optional data matrix for testing dataset}

\item{yvar}{column name for outcome}

\item{xvars}{a string vector of column names for input markers}

\item{trtvar}{column name for treatment (the column should contain binary code with 1 being treatment and 0 being control)}

\item{cvar}{column name for censor (the column should contain binary code with 1 being event and 0 being censored)}

\item{nfolds}{n fold CV used for cv.glmnet}

\item{type}{outcome type ("binary" for binary outcome and "survival" for time-to-event outcome)}
}
\value{
A list with ROCSI output
\describe{
  \item{beta.aABC}{final beta estimated from ROCSI based on \eqn{ABC^{(acv)}}}
  \item{beta.1se}{final beta estimated from lambda.1se based on nfold CV}
  \item{lambda.aABC}{optimal lambda selected by optimizing \eqn{ABC^{(acv)}}}
  \item{fit.cv}{fitted cv.glmnet model}
  \item{log}{log matrix of all lambdas and ABCs}
  \item{abc.test}{ABC in testing dataset based on optimal beta}
  \item{abc.test1se}{ABC in testing dataset based on 1se beta}
  \item{predScore}{a data.frame of testing data and its predictive signature scores (based on beta.aABC) for each subjects}
  \item{predScore.1se}{a data.frame of testing data and its predictive signature scores (based on beta.1se) for each subjects}
}
}
\description{
function for ROCSI
}
\details{
function for ROCSI
}
\examples{
n <- 100
k <- 5
prevalence <- sqrt(0.5)
rho<-0.2
sig2 <- 2
rhos.bt.real <- c(0, rep(0.1, (k-3)))*sig2
y.sig2 <- 1
yvar="y.binary"
xvars=paste("x", c(1:k), sep="")
trtvar="treatment"
prog.eff <- 0.5
effect.size <- 1
a.constent <- effect.size/(2*(1-prevalence))
ObsData <- data.gen(n=n, k=k, prevalence=prevalence, prog.eff=prog.eff,
                    sig2=sig2, y.sig2=y.sig2, rho=rho,
                    rhos.bt.real=rhos.bt.real, a.constent=a.constent)
TestData <- data.gen(n=n, k=k, prevalence=prevalence, prog.eff=prog.eff,
                     sig2=sig2, y.sig2=y.sig2, rho=rho,
                     rhos.bt.real=rhos.bt.real, a.constent=a.constent)
bst.aabc <- ROCSI(Dtrain=ObsData$data, Dtest = TestData$data, yvar=yvar,
xvars=xvars, trtvar=trtvar, cvar=NULL, nfolds=5, type="binary")
bst.aabc$beta.aABC
bst.aabc$log
bst.aabc$abc.test
bst.aabc$beta.1se
bst.aabc$abc.test1se
}
