#include <R.h>
#include <R_ext/Rdynload.h>

#include "niftilib/nifti1_io.h"
#include "niftilib/nifti2_io.h"

extern R_CallMethodDef callMethods[];

void R_init_RNifti (DllInfo *info)
{
    R_registerRoutines(info, NULL, callMethods, NULL, NULL);
    R_useDynamicSymbols(info, FALSE);
    
    R_RegisterCCallable("RNifti", "nii_datatype_string", (DL_FUNC) &nifti_datatype_string);
    R_RegisterCCallable("RNifti", "nii_units_string", (DL_FUNC) &nifti_units_string);
    R_RegisterCCallable("RNifti", "nii_intent_string", (DL_FUNC) &nifti_intent_string);
    R_RegisterCCallable("RNifti", "nii_xform_string", (DL_FUNC) &nifti_xform_string);
    R_RegisterCCallable("RNifti", "nii_slice_string", (DL_FUNC) &nifti_slice_string);
    R_RegisterCCallable("RNifti", "nii_orientation_string", (DL_FUNC) &nifti_orientation_string);
    R_RegisterCCallable("RNifti", "nii_is_inttype", (DL_FUNC) &nifti_is_inttype);
    R_RegisterCCallable("RNifti", "nii_mat44_inverse", (DL_FUNC) &nifti_mat44_inverse);
    R_RegisterCCallable("RNifti", "nii_mat33_inverse", (DL_FUNC) &nifti_mat33_inverse);
    R_RegisterCCallable("RNifti", "nii_mat33_polar", (DL_FUNC) &nifti_mat33_polar);
    R_RegisterCCallable("RNifti", "nii_mat33_rownorm", (DL_FUNC) &nifti_mat33_rownorm);
    R_RegisterCCallable("RNifti", "nii_mat33_colnorm", (DL_FUNC) &nifti_mat33_colnorm);
    R_RegisterCCallable("RNifti", "nii_mat33_determ", (DL_FUNC) &nifti_mat33_determ);
    R_RegisterCCallable("RNifti", "nii_mat33_mul", (DL_FUNC) &nifti_mat33_mul);
    R_RegisterCCallable("RNifti", "nii_swap_2bytes", (DL_FUNC) &nifti_swap_2bytes);
    R_RegisterCCallable("RNifti", "nii_swap_4bytes", (DL_FUNC) &nifti_swap_4bytes);
    R_RegisterCCallable("RNifti", "nii_swap_8bytes", (DL_FUNC) &nifti_swap_8bytes);
    R_RegisterCCallable("RNifti", "nii_swap_16bytes", (DL_FUNC) &nifti_swap_16bytes);
    R_RegisterCCallable("RNifti", "nii_swap_Nbytes", (DL_FUNC) &nifti_swap_Nbytes);
    R_RegisterCCallable("RNifti", "nii_datatype_is_valid", (DL_FUNC) &nifti_datatype_is_valid);
    R_RegisterCCallable("RNifti", "nii_datatype_from_string", (DL_FUNC) &nifti_datatype_from_string);
    R_RegisterCCallable("RNifti", "nii_datatype_to_string", (DL_FUNC) &nifti_datatype_to_string);
    R_RegisterCCallable("RNifti", "nii_get_filesize", (DL_FUNC) &nifti_get_filesize);
    R_RegisterCCallable("RNifti", "swap_nii_header", (DL_FUNC) &swap_nifti_header);
    R_RegisterCCallable("RNifti", "old_swap_nii_header", (DL_FUNC) &old_swap_nifti_header);
    R_RegisterCCallable("RNifti", "nii_swap_as_analyze", (DL_FUNC) &nifti_swap_as_analyze);
    R_RegisterCCallable("RNifti", "nii_image_read_bricks", (DL_FUNC) &nifti_image_read_bricks);
    R_RegisterCCallable("RNifti", "nii_image_load_bricks", (DL_FUNC) &nifti_image_load_bricks);
    R_RegisterCCallable("RNifti", "nii_free_NBL", (DL_FUNC) &nifti_free_NBL);
    R_RegisterCCallable("RNifti", "nii_image_read", (DL_FUNC) &nifti_image_read);
    R_RegisterCCallable("RNifti", "nii_image_load", (DL_FUNC) &nifti_image_load);
    R_RegisterCCallable("RNifti", "nii_image_unload", (DL_FUNC) &nifti_image_unload);
    R_RegisterCCallable("RNifti", "nii_image_free", (DL_FUNC) &nifti_image_free);
    R_RegisterCCallable("RNifti", "nii_read_collapsed_image", (DL_FUNC) &nifti_read_collapsed_image);
    R_RegisterCCallable("RNifti", "nii_read_subregion_image", (DL_FUNC) &nifti_read_subregion_image);
    R_RegisterCCallable("RNifti", "nii_image_write", (DL_FUNC) &nifti_image_write);
    R_RegisterCCallable("RNifti", "nii_image_write_status", (DL_FUNC) &nifti_image_write_status);
    R_RegisterCCallable("RNifti", "nii_image_write_bricks", (DL_FUNC) &nifti_image_write_bricks);
    R_RegisterCCallable("RNifti", "nii_image_write_bricks_status", (DL_FUNC) &nifti_image_write_bricks_status);
    R_RegisterCCallable("RNifti", "nii_image_infodump", (DL_FUNC) &nifti_image_infodump);
    R_RegisterCCallable("RNifti", "nii_disp_lib_hist", (DL_FUNC) &nifti_disp_lib_hist);
    R_RegisterCCallable("RNifti", "nii_disp_lib_version", (DL_FUNC) &nifti_disp_lib_version);
    R_RegisterCCallable("RNifti", "nii_disp_matrix_orient", (DL_FUNC) &nifti_disp_matrix_orient);
    R_RegisterCCallable("RNifti", "nii_disp_type_list", (DL_FUNC) &nifti_disp_type_list);
    R_RegisterCCallable("RNifti", "nii_image_to_ascii", (DL_FUNC) &nifti_image_to_ascii);
    R_RegisterCCallable("RNifti", "nii_image_from_ascii", (DL_FUNC) &nifti_image_from_ascii);
    R_RegisterCCallable("RNifti", "nii_get_volsize", (DL_FUNC) &nifti_get_volsize);
    R_RegisterCCallable("RNifti", "nii_set_filenames", (DL_FUNC) &nifti_set_filenames);
    R_RegisterCCallable("RNifti", "nii_makehdrname", (DL_FUNC) &nifti_makehdrname);
    R_RegisterCCallable("RNifti", "nii_makeimgname", (DL_FUNC) &nifti_makeimgname);
    R_RegisterCCallable("RNifti", "is_nii_file", (DL_FUNC) &is_nifti_file);
    R_RegisterCCallable("RNifti", "nii_find_file_extension", (DL_FUNC) &nifti_find_file_extension);
    R_RegisterCCallable("RNifti", "nii_is_complete_filename", (DL_FUNC) &nifti_is_complete_filename);
    R_RegisterCCallable("RNifti", "nii_validfilename", (DL_FUNC) &nifti_validfilename);
    R_RegisterCCallable("RNifti", "disp_nii_1_header", (DL_FUNC) &disp_nifti_1_header);
    R_RegisterCCallable("RNifti", "nii_set_debug_level", (DL_FUNC) &nifti_set_debug_level);
    R_RegisterCCallable("RNifti", "nii_set_skip_blank_ext", (DL_FUNC) &nifti_set_skip_blank_ext);
    R_RegisterCCallable("RNifti", "nii_set_allow_upper_fext", (DL_FUNC) &nifti_set_allow_upper_fext);
    R_RegisterCCallable("RNifti", "valid_nii_brick_list", (DL_FUNC) &valid_nifti_brick_list);
    R_RegisterCCallable("RNifti", "nii_image_open", (DL_FUNC) &nifti_image_open);
    R_RegisterCCallable("RNifti", "nii_image_write_hdr_img", (DL_FUNC) &nifti_image_write_hdr_img);
    R_RegisterCCallable("RNifti", "nii_image_write_hdr_img2", (DL_FUNC) &nifti_image_write_hdr_img2);
    R_RegisterCCallable("RNifti", "nii_read_buffer", (DL_FUNC) &nifti_read_buffer);
    R_RegisterCCallable("RNifti", "nii_write_all_data", (DL_FUNC) &nifti_write_all_data);
    R_RegisterCCallable("RNifti", "nii_write_buffer", (DL_FUNC) &nifti_write_buffer);
    R_RegisterCCallable("RNifti", "nii_read_ascii_image", (DL_FUNC) &nifti_read_ascii_image);
    R_RegisterCCallable("RNifti", "nii_write_ascii_image", (DL_FUNC) &nifti_write_ascii_image);
    R_RegisterCCallable("RNifti", "nii_datatype_sizes", (DL_FUNC) &nifti_datatype_sizes);
    R_RegisterCCallable("RNifti", "nii_mat44_to_quatern", (DL_FUNC) &nifti_mat44_to_quatern);
    R_RegisterCCallable("RNifti", "nii_quatern_to_mat44", (DL_FUNC) &nifti_quatern_to_mat44);
    R_RegisterCCallable("RNifti", "nii_make_orthog_mat44", (DL_FUNC) &nifti_make_orthog_mat44);
    R_RegisterCCallable("RNifti", "nii_short_order", (DL_FUNC) &nifti_short_order);
    R_RegisterCCallable("RNifti", "nii_mat44_to_orientation", (DL_FUNC) &nifti_mat44_to_orientation);
    R_RegisterCCallable("RNifti", "nii_findhdrname", (DL_FUNC) &nifti_findhdrname);
    R_RegisterCCallable("RNifti", "nii_findimgname", (DL_FUNC) &nifti_findimgname);
    R_RegisterCCallable("RNifti", "nii_is_gzfile", (DL_FUNC) &nifti_is_gzfile);
    R_RegisterCCallable("RNifti", "nii_makebasename", (DL_FUNC) &nifti_makebasename);
    R_RegisterCCallable("RNifti", "nii_convert_nim2nhdr", (DL_FUNC) &nifti_convert_nim2nhdr);
    R_RegisterCCallable("RNifti", "nii_make_new_header", (DL_FUNC) &nifti_make_new_header);
    R_RegisterCCallable("RNifti", "nii_read_header", (DL_FUNC) &nifti_read_header);
    R_RegisterCCallable("RNifti", "nii_copy_nim_info", (DL_FUNC) &nifti_copy_nim_info);
    R_RegisterCCallable("RNifti", "nii_make_new_nim", (DL_FUNC) &nifti_make_new_nim);
    R_RegisterCCallable("RNifti", "nii_simple_init_nim", (DL_FUNC) &nifti_simple_init_nim);
    R_RegisterCCallable("RNifti", "nii_convert_nhdr2nim", (DL_FUNC) &nifti_convert_nhdr2nim);
    R_RegisterCCallable("RNifti", "nii_hdr_looks_good", (DL_FUNC) &nifti_hdr_looks_good);
    R_RegisterCCallable("RNifti", "nii_is_valid_datatype", (DL_FUNC) &nifti_is_valid_datatype);
    R_RegisterCCallable("RNifti", "nii_is_valid_ecode", (DL_FUNC) &nifti_is_valid_ecode);
    R_RegisterCCallable("RNifti", "nii_nim_is_valid", (DL_FUNC) &nifti_nim_is_valid);
    R_RegisterCCallable("RNifti", "nii_nim_has_valid_dims", (DL_FUNC) &nifti_nim_has_valid_dims);
    R_RegisterCCallable("RNifti", "is_valid_nii_type", (DL_FUNC) &is_valid_nifti_type);
    R_RegisterCCallable("RNifti", "nii_test_datatype_sizes", (DL_FUNC) &nifti_test_datatype_sizes);
    R_RegisterCCallable("RNifti", "nii_type_and_names_match", (DL_FUNC) &nifti_type_and_names_match);
    R_RegisterCCallable("RNifti", "nii_update_dims_from_array", (DL_FUNC) &nifti_update_dims_from_array);
    R_RegisterCCallable("RNifti", "nii_set_iname_offset", (DL_FUNC) &nifti_set_iname_offset);
    R_RegisterCCallable("RNifti", "nii_set_type_from_names", (DL_FUNC) &nifti_set_type_from_names);
    R_RegisterCCallable("RNifti", "nii_add_extension", (DL_FUNC) &nifti_add_extension);
    R_RegisterCCallable("RNifti", "nii_compiled_with_zlib", (DL_FUNC) &nifti_compiled_with_zlib);
    R_RegisterCCallable("RNifti", "nii_copy_extensions", (DL_FUNC) &nifti_copy_extensions);
    R_RegisterCCallable("RNifti", "nii_free_extensions", (DL_FUNC) &nifti_free_extensions);
    R_RegisterCCallable("RNifti", "nii_get_intlist", (DL_FUNC) &nifti_get_intlist);
    R_RegisterCCallable("RNifti", "nii_strdup", (DL_FUNC) &nifti_strdup);
    R_RegisterCCallable("RNifti", "valid_nii_extensions", (DL_FUNC) &valid_nifti_extensions);
    R_RegisterCCallable("RNifti", "nii_mat44_mul", (DL_FUNC) &nifti_mat44_mul);
    R_RegisterCCallable("RNifti", "nii_dmat44_inverse", (DL_FUNC) &nifti_dmat44_inverse);
    R_RegisterCCallable("RNifti", "nii_mat44_to_dmat44", (DL_FUNC) &nifti_mat44_to_dmat44);
    R_RegisterCCallable("RNifti", "nii_dmat44_to_mat44", (DL_FUNC) &nifti_dmat44_to_mat44);
    R_RegisterCCallable("RNifti", "nii_dmat44_mul", (DL_FUNC) &nifti_dmat44_mul);
    R_RegisterCCallable("RNifti", "nii_dmat33_inverse", (DL_FUNC) &nifti_dmat33_inverse);
    R_RegisterCCallable("RNifti", "nii_dmat33_polar", (DL_FUNC) &nifti_dmat33_polar);
    R_RegisterCCallable("RNifti", "nii_dmat33_rownorm", (DL_FUNC) &nifti_dmat33_rownorm);
    R_RegisterCCallable("RNifti", "nii_dmat33_colnorm", (DL_FUNC) &nifti_dmat33_colnorm);
    R_RegisterCCallable("RNifti", "nii_dmat33_determ", (DL_FUNC) &nifti_dmat33_determ);
    R_RegisterCCallable("RNifti", "nii_dmat33_mul", (DL_FUNC) &nifti_dmat33_mul);
    R_RegisterCCallable("RNifti", "nii_header_version", (DL_FUNC) &nifti_header_version);
    R_RegisterCCallable("RNifti", "nii2_get_filesize", (DL_FUNC) &nifti2_get_filesize);
    R_RegisterCCallable("RNifti", "nii_swap_as_nifti1", (DL_FUNC) &nifti_swap_as_nifti1);
    R_RegisterCCallable("RNifti", "nii_swap_as_nifti2", (DL_FUNC) &nifti_swap_as_nifti2);
    R_RegisterCCallable("RNifti", "nii2_image_read_bricks", (DL_FUNC) &nifti2_image_read_bricks);
    R_RegisterCCallable("RNifti", "nii2_image_load_bricks", (DL_FUNC) &nifti2_image_load_bricks);
    R_RegisterCCallable("RNifti", "nii2_free_NBL", (DL_FUNC) &nifti2_free_NBL);
    R_RegisterCCallable("RNifti", "nii2_image_read", (DL_FUNC) &nifti2_image_read);
    R_RegisterCCallable("RNifti", "nii2_image_load", (DL_FUNC) &nifti2_image_load);
    R_RegisterCCallable("RNifti", "nii2_image_unload", (DL_FUNC) &nifti2_image_unload);
    R_RegisterCCallable("RNifti", "nii2_image_free", (DL_FUNC) &nifti2_image_free);
    R_RegisterCCallable("RNifti", "nii2_read_collapsed_image", (DL_FUNC) &nifti2_read_collapsed_image);
    R_RegisterCCallable("RNifti", "nii2_read_subregion_image", (DL_FUNC) &nifti2_read_subregion_image);
    R_RegisterCCallable("RNifti", "nii2_image_write", (DL_FUNC) &nifti2_image_write);
    R_RegisterCCallable("RNifti", "nii2_image_write_status", (DL_FUNC) &nifti2_image_write_status);
    R_RegisterCCallable("RNifti", "nii2_image_write_bricks", (DL_FUNC) &nifti2_image_write_bricks);
    R_RegisterCCallable("RNifti", "nii2_image_write_bricks_status", (DL_FUNC) &nifti2_image_write_bricks_status);
    R_RegisterCCallable("RNifti", "nii2_image_infodump", (DL_FUNC) &nifti2_image_infodump);
    R_RegisterCCallable("RNifti", "nii2_disp_lib_hist", (DL_FUNC) &nifti2_disp_lib_hist);
    R_RegisterCCallable("RNifti", "nii2_disp_matrix_orient", (DL_FUNC) &nifti2_disp_matrix_orient);
    R_RegisterCCallable("RNifti", "nii2_image_to_ascii", (DL_FUNC) &nifti2_image_to_ascii);
    R_RegisterCCallable("RNifti", "nii2_image_from_ascii", (DL_FUNC) &nifti2_image_from_ascii);
    R_RegisterCCallable("RNifti", "nii2_get_volsize", (DL_FUNC) &nifti2_get_volsize);
    R_RegisterCCallable("RNifti", "nii2_set_filenames", (DL_FUNC) &nifti2_set_filenames);
    R_RegisterCCallable("RNifti", "disp_nii_2_header", (DL_FUNC) &disp_nifti_2_header);
    R_RegisterCCallable("RNifti", "nii_get_alter_cifti", (DL_FUNC) &nifti_get_alter_cifti);
    R_RegisterCCallable("RNifti", "nii_set_alter_cifti", (DL_FUNC) &nifti_set_alter_cifti);
    R_RegisterCCallable("RNifti", "nii_alter_cifti_dims", (DL_FUNC) &nifti_alter_cifti_dims);
    R_RegisterCCallable("RNifti", "valid_nii2_brick_list", (DL_FUNC) &valid_nifti2_brick_list);
    R_RegisterCCallable("RNifti", "nii2_image_open", (DL_FUNC) &nifti2_image_open);
    R_RegisterCCallable("RNifti", "nii2_image_write_hdr_img", (DL_FUNC) &nifti2_image_write_hdr_img);
    R_RegisterCCallable("RNifti", "nii2_image_write_hdr_img2", (DL_FUNC) &nifti2_image_write_hdr_img2);
    R_RegisterCCallable("RNifti", "nii2_read_buffer", (DL_FUNC) &nifti2_read_buffer);
    R_RegisterCCallable("RNifti", "nii2_write_all_data", (DL_FUNC) &nifti2_write_all_data);
    R_RegisterCCallable("RNifti", "nii2_write_buffer", (DL_FUNC) &nifti2_write_buffer);
    R_RegisterCCallable("RNifti", "nii2_read_ascii_image", (DL_FUNC) &nifti2_read_ascii_image);
    R_RegisterCCallable("RNifti", "nii2_write_ascii_image", (DL_FUNC) &nifti2_write_ascii_image);
    R_RegisterCCallable("RNifti", "nii_dmat44_to_quatern", (DL_FUNC) &nifti_dmat44_to_quatern);
    R_RegisterCCallable("RNifti", "nii_quatern_to_dmat44", (DL_FUNC) &nifti_quatern_to_dmat44);
    R_RegisterCCallable("RNifti", "nii_make_orthog_dmat44", (DL_FUNC) &nifti_make_orthog_dmat44);
    R_RegisterCCallable("RNifti", "nii_dmat44_to_orientation", (DL_FUNC) &nifti_dmat44_to_orientation);
    R_RegisterCCallable("RNifti", "nii_convert_nim2n1hdr", (DL_FUNC) &nifti_convert_nim2n1hdr);
    R_RegisterCCallable("RNifti", "nii_convert_nim2n2hdr", (DL_FUNC) &nifti_convert_nim2n2hdr);
    R_RegisterCCallable("RNifti", "nii_make_new_n1_header", (DL_FUNC) &nifti_make_new_n1_header);
    R_RegisterCCallable("RNifti", "nii_make_new_n2_header", (DL_FUNC) &nifti_make_new_n2_header);
    R_RegisterCCallable("RNifti", "nii2_read_header", (DL_FUNC) &nifti2_read_header);
    R_RegisterCCallable("RNifti", "nii_read_n1_hdr", (DL_FUNC) &nifti_read_n1_hdr);
    R_RegisterCCallable("RNifti", "nii_read_n2_hdr", (DL_FUNC) &nifti_read_n2_hdr);
    R_RegisterCCallable("RNifti", "nii2_copy_nim_info", (DL_FUNC) &nifti2_copy_nim_info);
    R_RegisterCCallable("RNifti", "nii2_make_new_nim", (DL_FUNC) &nifti2_make_new_nim);
    R_RegisterCCallable("RNifti", "nii2_simple_init_nim", (DL_FUNC) &nifti2_simple_init_nim);
    R_RegisterCCallable("RNifti", "nii_convert_n1hdr2nim", (DL_FUNC) &nifti_convert_n1hdr2nim);
    R_RegisterCCallable("RNifti", "nii_convert_n2hdr2nim", (DL_FUNC) &nifti_convert_n2hdr2nim);
    R_RegisterCCallable("RNifti", "nii_looks_like_cifti", (DL_FUNC) &nifti_looks_like_cifti);
    R_RegisterCCallable("RNifti", "nii_hdr1_looks_good", (DL_FUNC) &nifti_hdr1_looks_good);
    R_RegisterCCallable("RNifti", "nii_hdr2_looks_good", (DL_FUNC) &nifti_hdr2_looks_good);
    R_RegisterCCallable("RNifti", "nii2_nim_is_valid", (DL_FUNC) &nifti2_nim_is_valid);
    R_RegisterCCallable("RNifti", "nii2_nim_has_valid_dims", (DL_FUNC) &nifti2_nim_has_valid_dims);
    R_RegisterCCallable("RNifti", "is_valid_nii2_type", (DL_FUNC) &is_valid_nifti2_type);
    R_RegisterCCallable("RNifti", "nii2_type_and_names_match", (DL_FUNC) &nifti2_type_and_names_match);
    R_RegisterCCallable("RNifti", "nii2_update_dims_from_array", (DL_FUNC) &nifti2_update_dims_from_array);
    R_RegisterCCallable("RNifti", "nii2_set_iname_offset", (DL_FUNC) &nifti2_set_iname_offset);
    R_RegisterCCallable("RNifti", "nii2_set_type_from_names", (DL_FUNC) &nifti2_set_type_from_names);
    R_RegisterCCallable("RNifti", "nii2_add_extension", (DL_FUNC) &nifti2_add_extension);
    R_RegisterCCallable("RNifti", "nii2_copy_extensions", (DL_FUNC) &nifti2_copy_extensions);
    R_RegisterCCallable("RNifti", "nii2_free_extensions", (DL_FUNC) &nifti2_free_extensions);
    R_RegisterCCallable("RNifti", "nii_get_int64list", (DL_FUNC) &nifti_get_int64list);
    R_RegisterCCallable("RNifti", "valid_nii2_extensions", (DL_FUNC) &valid_nifti2_extensions);
    R_RegisterCCallable("RNifti", "nii_valid_header_size", (DL_FUNC) &nifti_valid_header_size);
}
