% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff_expression.R
\name{plot_gene}
\alias{plot_gene}
\title{Plot a gene}
\usage{
plot_gene(
  gene,
  dds,
  x_var = NULL,
  color_by = NULL,
  point_alpha = 0.7,
  point_rel_size = 2,
  show_plot = TRUE
)
}
\arguments{
\item{gene}{A gene ID or gene name, i.e. an element of \code{rownames(dds)} or of \code{rowData(dds)$gene_name}}

\item{dds}{a DESeqDataSet}

\item{x_var}{Variable to plot on the x-axis. If NULL, then each sample is plotted separately.}

\item{color_by}{Variable (column in \code{colData(dds)}) to color points by.}

\item{point_alpha}{alpha value of \code{geom_point()}}

\item{point_rel_size}{relative size of \code{geom_point()}}

\item{show_plot}{Whether to show the plot or not}
}
\value{
The function displays the plot and returns invisible the data frame of
expression values and colData annotation for the gene.
}
\description{
Plot a gene
}
\examples{
library("DESeq2")
set.seed(1)
dds <- makeExampleDESeqDataSet()
colData(dds)$type <- c("A","A","A","B","B","B")
colData(dds)$patient <- c("1","1","2","2","3","3")
dds <- estimateSizeFactors(dds)
plot_gene("gene1", dds)
plot_gene("gene1", dds, x_var="patient", color_by="type")

}
