% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{encodeSlof}
\alias{encodeSlof}
\title{encodeSlof}
\usage{
encodeSlof(data, fixedPoint)
}
\arguments{
\item{data}{pointer to array of double to be encoded (need memorycont. repr.)}

\item{fixedPoint}{fixed point to use for encoding (see optimalSlofFixedPoint)}
}
\value{
the number of encoded bytes
}
\description{
Encodes ion counts by taking the natural logarithm, and storing a
  fixed point representation of this. This is calculated as
  
  unsigned short fp = log(d + 1) * fixedPoint + 0.5
}
\details{
the result vector is exactly |data| * 2 + 8 bytes long
}
\seealso{
[\code{\link{decodeSlof}}]
}
