% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{encodeLinear}
\alias{encodeLinear}
\title{encodeLinear}
\usage{
encodeLinear(data, fixedPoint)
}
\arguments{
\item{data}{pointer to array of double to be encoded (need memorycont. repr.)}

\item{fixedPoint}{the scaling factor used for getting the fixed point repr. 
This is stored in the binary and automatically extracted
on decoding (see optimalLinearFixedPoint or optimalLinearFixedPointMass)}
}
\value{
the number of encoded bytes
}
\description{
Encodes the doubles in data by first using a \cr
 - lossy conversion to a 4 byte 5 decimal fixed point representation \cr
 - storing the residuals from a linear prediction after first two values \cr
 - encoding by encodeInt (see above) \cr
 
 The resulting binary is maximally 8 + dataSize * 5 bytes, but much less if the 
   data is reasonably smooth on the first order.
 
 This encoding is suitable for typical m/z or retention time binary arrays. 
 On a test set, the encoding was empirically show to be accurate to at least 0.002 ppm.
}
\examples{
\dontrun{
## Retention time array
rt_array <- c(4313.0, 4316.4, 4319.8, 4323.2, 4326.6, 4330.1)
## encode retention time array
rt_encoded <- encodeLinear(rt_array, 500)
#> [1] 40 7f 40 00 00 00 00 00 d4 e7 20 00 78 ee 20 00 88 86 23
}
}
\seealso{
[\code{\link{decodeLinear}}]
}
