% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmv.R
\name{rMvReturnSim}
\alias{rMvReturnSim}
\title{Simulate Stocks Prices}
\usage{
rMvReturnSim(
  names,
  date,
  mu = rep(0, 2),
  sigma = matrix(c(1, 0.5, 0.5, 1), 2, 2)
)
}
\arguments{
\item{names}{vector of names}

\item{date}{vector of time, must be "Date" type}

\item{mu}{vector of \code{mu}}

\item{sigma}{vector of \code{sigma}}
}
\value{
Multivariate stock prices
}
\description{
Simulate stocks prices following multivariate normal distribution.
}
\examples{
names <- c("swan", "bear")
date <- as.Date("2015-01-01") + days(0:29)
rMvReturnSim(names, date)
}
