% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backtest.R
\name{rGbms}
\alias{rGbms}
\title{Simulate Multivariate Stocks Prices Data}
\usage{
rGbms(
  name,
  len,
  start = c(1000, 1000),
  mu = rep(1e-04, 2),
  sigma = matrix(c(2e-04, 1e-04, 1e-04, 2e-04), 2, 2),
  digits = 2
)
}
\arguments{
\item{name}{vector of series names}

\item{len}{the length}

\item{start}{vector of start positions}

\item{mu}{vector of \code{mu}}

\item{sigma}{vector of \code{sigma}}

\item{digits}{integer deciding the number of decimal places}
}
\value{
A simulated multivariate GBM series with each series interconnected
}
\description{
Simulate multivariate prices for interconnected stocks with each price series following Geometric Brownian Motion (GBM).
}
\examples{
rGbms(c("bear", "tiger"), len = 36)
}
