/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.regression;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.linearfilters.RationalBackFilter;
import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.regression.AbstractOutlierVariable;
import ec.tstoolkit.timeseries.regression.IOutlierVariable;
import ec.tstoolkit.timeseries.regression.OutlierType;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsPeriod;

public class SwitchOutlier
extends AbstractOutlierVariable {
    public static final String CODE = "WO";

    public SwitchOutlier(Day p) {
        super(p);
    }

    @Override
    public void data(TsPeriod start, DataBlock data) {
        TsPeriod pstart = new TsPeriod(start.getFrequency(), this.position);
        int pos = pstart.minus(start);
        data.set(0.0);
        if (pos >= 0) {
            data.set(pos, 1.0);
        }
        if (pos + 1 < data.getLength()) {
            data.set(pos + 1, -1.0);
        }
    }

    @Override
    public OutlierType getOutlierType() {
        return OutlierType.WO;
    }

    @Override
    public boolean isSignificant(TsDomain domain) {
        int p = domain.search(this.position);
        return p >= 0 && p < domain.getLength() - 1;
    }

    @Override
    public IOutlierVariable.FilterRepresentation getFilterRepresentation(int freq) {
        return new IOutlierVariable.FilterRepresentation(new RationalBackFilter(BackFilter.D1, BackFilter.ONE), 0.0);
    }

    @Override
    public String getCode() {
        return CODE;
    }
}

