/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.regression;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import java.util.List;

public class SeasonalDummies
implements ITsVariable {
    TsFrequency freq_;

    public SeasonalDummies(TsFrequency freq) {
        this.freq_ = freq;
    }

    @Override
    public void data(TsDomain domain, List<DataBlock> data) {
        int pstart = domain.getStart().getPosition();
        int ifreq = domain.getFrequency().intValue();
        int lstart = ifreq - pstart - 1;
        if (lstart < 0) {
            lstart += ifreq;
        }
        for (int i = 0; i < ifreq - 1; ++i) {
            DataBlock x = data.get(i);
            int jstart = i - pstart;
            if (jstart < 0) {
                jstart += ifreq;
            }
            DataBlock m = x.extract(jstart, -1, ifreq);
            m.set(1.0);
            DataBlock q = x.extract(lstart, -1, ifreq);
            q.set(-1.0);
        }
    }

    @Override
    public TsDomain getDefinitionDomain() {
        return null;
    }

    @Override
    public TsFrequency getDefinitionFrequency() {
        return this.freq_;
    }

    @Override
    public String getDescription(TsFrequency context) {
        StringBuilder builder = new StringBuilder();
        builder.append("Seasonal dummies");
        return builder.toString();
    }

    @Override
    public int getDim() {
        return this.freq_.intValue() - 1;
    }

    @Override
    public String getItemDescription(int idx, TsFrequency context) {
        StringBuilder builder = new StringBuilder();
        builder.append("Seasonal dummy [").append(idx + 1).append(']');
        return builder.toString();
    }

    @Override
    public boolean isSignificant(TsDomain domain) {
        return domain.getFrequency() != TsFrequency.Yearly;
    }

    @Override
    public String getName() {
        return "seas#" + this.getDim();
    }
}

