/*
 * Decompiled with CFR 0.152.
 */
package ec.benchmarking.ssf;

import ec.benchmarking.BaseDisaggregation;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.SubArrayOfInt;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.ssf.ISsf;

public class SsfFernandez
extends BaseDisaggregation
implements ISsf {
    public SsfFernandez() {
    }

    public SsfFernandez(int conv) {
        super(conv);
    }

    public SsfFernandez(SsfFernandez expander) {
        super(expander);
    }

    @Override
    public void diffuseConstraints(SubMatrix b) {
        b.set(1, 0, 1.0);
    }

    @Override
    public void fullQ(int pos, SubMatrix qm) {
        qm.set(1, 1, 1.0);
    }

    @Override
    public int getNonStationaryDim() {
        return 1;
    }

    @Override
    public int getStateDim() {
        return 2;
    }

    @Override
    public int getTransitionResCount() {
        return 1;
    }

    @Override
    public int getTransitionResDim() {
        return 1;
    }

    @Override
    public boolean hasR() {
        return true;
    }

    @Override
    public boolean hasTransitionRes(int pos) {
        return true;
    }

    @Override
    public boolean hasW() {
        return false;
    }

    @Override
    public boolean isDiffuse() {
        return true;
    }

    @Override
    public boolean isMeasurementEquationTimeInvariant() {
        return false;
    }

    @Override
    public boolean isTimeInvariant() {
        return false;
    }

    @Override
    public boolean isTransitionEquationTimeInvariant() {
        return false;
    }

    @Override
    public boolean isTransitionResidualTimeInvariant() {
        return true;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void L(int pos, DataBlock k, SubMatrix lm) {
        if ((pos + 1) % this.conversion == 0) {
            lm.set(0, 0, -k.get(0));
            lm.set(0, 1, -k.get(0));
            lm.set(1, 0, -k.get(1));
            lm.set(1, 1, 1.0 - k.get(1));
        } else if (pos % this.conversion == 0) {
            lm.set(0, 1, 1.0 - k.get(0));
            lm.set(1, 1, 1.0 - k.get(1));
        } else {
            lm.set(0, 0, 1.0 - k.get(0));
            lm.set(0, 1, -k.get(0));
            lm.set(1, 0, 1.0 - k.get(1));
            lm.set(1, 1, 1.0 - k.get(1));
        }
    }

    @Override
    public void Pf0(SubMatrix pf0) {
        pf0.set(1, 1, 1.0);
    }

    @Override
    public void Pi0(SubMatrix pi0) {
        pi0.set(1, 1, 1.0);
    }

    @Override
    public void Q(int pos, SubMatrix qm) {
        qm.set(0, 0, 1.0);
    }

    @Override
    public void R(int pos, SubArrayOfInt rv) {
        rv.set(0, 1);
    }

    @Override
    public void T(int pos, SubMatrix tr) {
        tr.set(1, 1, 1.0);
        if ((pos + 1) % this.conversion != 0) {
            tr.set(0, 1, 1.0);
            if (pos % this.conversion != 0) {
                tr.set(0, 0, 1.0);
            }
        }
    }

    @Override
    public void TVT(int pos, SubMatrix vm) {
        if ((pos + 1) % this.conversion == 0) {
            vm.set(0, 0, 0.0);
            vm.set(0, 1, 0.0);
            vm.set(1, 0, 0.0);
        } else if (pos % this.conversion == 0) {
            double v = vm.get(1, 1);
            vm.set(0, 0, v);
            vm.set(0, 1, v);
            vm.set(1, 0, v);
        } else {
            double v = vm.get(1, 1);
            vm.add(0, 0, 2.0 * vm.get(0, 1) + v);
            vm.add(0, 1, v);
            vm.add(1, 0, v);
        }
    }

    @Override
    public void TX(int pos, DataBlock x) {
        if ((pos + 1) % this.conversion == 0) {
            x.set(0, 0.0);
        } else if (pos % this.conversion == 0) {
            x.set(0, x.get(1));
        } else {
            x.add(0, x.get(1));
        }
    }

    @Override
    public void VpZdZ(int pos, SubMatrix vm, double d) {
        if (pos % this.conversion == 0) {
            vm.add(1, 1, d);
        } else {
            vm.add(d);
        }
    }

    @Override
    public void W(int pos, SubMatrix wv) {
    }

    @Override
    public void XpZd(int pos, DataBlock x, double d) {
        x.add(1, d);
        if (pos % this.conversion != 0) {
            x.add(0, d);
        }
    }

    @Override
    public void XT(int pos, DataBlock x) {
        if ((pos + 1) % this.conversion == 0) {
            x.set(0, 0.0);
        } else if (pos % this.conversion == 0) {
            x.add(1, x.get(0));
            x.set(0, 0.0);
        } else {
            x.add(1, x.get(0));
        }
    }

    @Override
    public void Z(int pos, DataBlock z) {
        z.set(1, 1.0);
        if (pos % this.conversion != 0) {
            z.set(0, 1.0);
        }
    }

    @Override
    public void ZM(int pos, SubMatrix m, DataBlock x) {
        x.copy(m.row(1));
        if (pos % this.conversion != 0) {
            x.add(m.row(0));
        }
    }

    @Override
    public double ZVZ(int pos, SubMatrix vm) {
        if (pos % this.conversion == 0) {
            return vm.get(1, 1);
        }
        return vm.get(0, 0) + vm.get(1, 1) + 2.0 * vm.get(0, 1);
    }

    @Override
    public double ZX(int pos, DataBlock x) {
        if (pos % this.conversion == 0) {
            return x.get(1);
        }
        return x.get(0) + x.get(1);
    }
}

