% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StationaryFrequencyAnalysis.R
\name{CalculatePSD}
\alias{CalculatePSD}
\title{Spectral Density Estimation}
\usage{
CalculatePSD(
  HRVData,
  indexFreqAnalysis = length(HRVData$FreqAnalysis),
  method = c("pgram", "ar", "lomb"),
  doPlot = T,
  ...
)
}
\arguments{
\item{HRVData}{Data structure that stores the beats register and information 
related to it.}

\item{indexFreqAnalysis}{An integer referencing the data structure that will contain 
the frequency analysis.}

\item{method}{String specifying the method used to estimate the spectral 
density. Allowed methods are "pgram" (the default), "ar" and "lomb".}

\item{doPlot}{Plot the periodogram?}

\item{...}{Further arguments to specific PSD estimation methods or 
\code{\link[RHRV]{PlotPSD}}.}
}
\value{
The \emph{CalculatePSD} returns the \emph{HRVData} structure 
containing a \emph{periodogram} field storing and PSD estimation 
of the RR time series. When the "pgram" and "ar" methods are used the
\emph{periodogram} field is an object of class "spec". If "lomb" is used,
the \emph{periodogram} field is just a list. In any case the 
\emph{periodogram} field will contain:
\itemize{
 \item{freq: vector of frequencies at which the spectral density is estimated.}
 \item{spec: spectral density estimation }
 \item{series: name of the series}
 \item{method: method used to calculate the spectrum}
}
}
\description{
Estimate the Power Spectral Density (PSD) of the RR time series.
}
\details{
The "pgram" and "ar" methods use the \code{\link[stats]{spec.pgram}}
and \code{\link[stats]{spec.ar}} functions. Thus, the same arguments used
in  \code{\link[stats]{spec.pgram}} or \code{\link[stats]{spec.ar}} 
can be used when method is "pgram" or "ar", respectively.
The "lomb"  is based in the \code{\link[lomb]{lsp}} and thus it accepts the
same parameters as this function.
}
\examples{
\dontrun{
data(HRVData)
HRVData=BuildNIHR(HRVData)
HRVData=FilterNIHR(HRVData)
# Frequency analysis requires interpolated data (except Lomb)
HRVData=InterpolateNIHR(HRVData)
# Create a different freqAnalysis for each method
HRVData=CreateFreqAnalysis(HRVData)
HRVData=CalculatePSD(HRVData,1,"pgram",doPlot = F)

HRVData=CreateFreqAnalysis(HRVData)
HRVData=CalculatePSD(HRVData,2,"pgram",spans=9, doPlot = F)

HRVData=CreateFreqAnalysis(HRVData)
HRVData=CalculatePSD(HRVData,3,"ar",doPlot = F)

HRVData=CreateFreqAnalysis(HRVData)
HRVData=CalculatePSD(HRVData,4,"lomb",doPlot = F)
# Plot the results
layout(matrix(c(1,2,3,4), 2, 2, byrow = TRUE))
PlotPSD(HRVData,1)
PlotPSD(HRVData,2)
PlotPSD(HRVData,3)
PlotPSD(HRVData,4)
}
}
\seealso{
\code{\link[stats]{spectrum}}, \code{\link[RHRV]{PlotPSD}}.
}
