% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse_matrix_benchmark.R
\name{GetSparseCholeskyDefaultMicrobenchmarks}
\alias{GetSparseCholeskyDefaultMicrobenchmarks}
\title{Initializes the list of default sparse Cholesky factorization
microbenchmarks}
\usage{
GetSparseCholeskyDefaultMicrobenchmarks()
}
\value{
a list of \code{SparseMatrixMicrobenchmark} objects defining the
  microbenchmarks to be executed.  The microbenchmarks appear in the order
  listed in the function description and are assigned the names enumerated
  in the description.
}
\description{
\code{GetSparseCholeskyDefaultMicrobenchmarks} defines the default sparse
Cholesky factorization microbenchmarks to be executed by the
\code{\link{RunSparseMatrixBenchmark}} function.  The current sparse
Cholesky factorization microbenchmarks cover a variety of matrices of
different dimensions and number of non-zero values.  They are as follows:
\enumerate{
  \item cholesky_ct20stif -- Boeing structural matrix with 2600295 nonzeros
  \item cholesky_Andrews -- computer vision matrix with 760154
  \item cholesky_G3_circuit -- AMD circuit simulation matrix with 7660826
     nonzeros
}
See the documentation for the
\code{\link{SparseMatrixMicrobenchmark}} class for more details.
}
\seealso{
\code{\link{SparseMatrixMicrobenchmark}}

Other sparse matrix default microbenchmarks: \code{\link{GetSparseCholeskyExampleMicrobenchmarks}},
  \code{\link{GetSparseLuDefaultMicrobenchmarks}},
  \code{\link{GetSparseMatrixVectorDefaultMicrobenchmarks}},
  \code{\link{GetSparseMatrixVectorExampleMicrobenchmarks}},
  \code{\link{GetSparseQrDefaultMicrobenchmarks}}
}
