% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dephase_chrom.R
\docType{methods}
\name{dephase_chrom}
\alias{dephase_chrom}
\alias{dephase_chrom,GCxGC-method}
\title{Method dephase_chrom}
\usage{
dephase_chrom(Object, rel_dephase)

\S4method{dephase_chrom}{GCxGC}(Object, rel_dephase)
}
\arguments{
\item{Object}{a GCxGC class object}

\item{rel_dephase}{a numeric value from 0 to 100 with the relative dephasing
position.}
}
\description{
`dephase_chrom` shifts the retention time in the second
 dimension of the two-dimensional chromatogram. This procedure is usually
 applied in cases when part of peaks is splited in at the final and beginning
 of the second dimension. Also, the solvent effect and column bleeding can
 be removing by dephasing the chromatogram. The dephasing procedure is
 performing by splitting the chromagram with the relative value provided.
}
\examples{
\donttest{ 
 library(colorRamps)
 GB08_fl <- system.file("extdata", "08GB.cdf", package = "RGCxGC")
 GB08 <- read_chrom(GB08_fl, 5L)
 plot(GB08, nlevels = 150, color.palette = matlab.like,
      main = "No dephased chromatogram")
 GB08_d25 <- dephase_chrom(GB08, 25)
 plot(GB08_d25, nlevels = 150, color.palette = matlab.like,
      main = "25\% dephased chromatogram")
 }
}
