% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_s3_rendoboots.R
\name{confint.rendo.boots}
\alias{confint.rendo.boots}
\title{Confidence Intervals for Bootstrapped Model Parameters}
\usage{
\method{confint}{rendo.boots}(object, parm, level = 0.95, ...)
}
\arguments{
\item{object}{a fitted model object with bootstrapped parameters. Typically from \code{copulaCorrection}}

\item{parm}{a specification of which parameters are to be given
    confidence intervals, either a vector of numbers or a vector of
    names.  If missing, all parameters are considered.}

\item{level}{the confidence level required.}

\item{...}{ignored, for consistency with the generic function.}
}
\description{
Confidence Intervals for Bootstrapped Model Parameters
}
\details{
Computes the two-sided percentile confidence intervals from the bootstrapped parameter estimates. The intervals are
obtained by selecting the quantile of the bootstrapped parameter estimates corresponding to the given alpha level.

A minimum of \ifelse{html}{\out{1/min(level, 1-level)}}{\eqn{\frac{1}{min(level, 1-level)}}}
parameters estimates are needed to derive the confidence interval. The reason for this is that there is
otherwise no natural way to derive the percentiles (ie one cannot reasonably estimate the 95\% quantile of only 7 values).
}
