% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_item_icon_path.R
\name{get_item_icon_path}
\alias{get_item_icon_path}
\title{Icon Paths for items}
\usage{
get_item_icon_path(iconname, icontype = c("0", "1", "3"), dota_id = 570,
  language = "en", key = NULL)
}
\arguments{
\item{iconname}{The item icon name.}

\item{icontype}{(optional) The type of image you want.

\itemize{
  \item 0 - normal
  \item 1 - large
  \item 3 - ingame
}}

\item{dota_id}{Can take one of three values.

\itemize{
 \item 570 - Dota 2 (default)
 \item 816 - Dota 2 Internal Test
 \item 205790 - Dota 2 Beta Test
}}

\item{language}{The ISO639-1 language code for returning all the information in the corresponding
language. If the language is not supported, english will be returned. For a complete list of the
ISO639-1 language codes please visit \url{https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes}.}

\item{key}{The api key obtained from Steam. If you don't have one please visit
\url{https://steamcommunity.com/dev} in order to do so. For instructions on the correct way
to use this key please visit \url{https://github.com/LyzandeR/RDota2} and check the readme file.
You can also see the examples. A key can be made available to all the functions by using
\code{key_actions}. The key argument in individual functions should only be used in case the
user needs to work with multiple keys.}
}
\value{
A dota_api object containing the elements described in the details.
}
\description{
Icon Paths for items.
}
\details{
A list will be returned that contains three elements. The content, the url and the response
received from the api.

There is no documentation for the result of the request as it is still in the TODO (at the
moment of writing). Please see the Steam API Documentation below.
}
\section{Steam API Documentation}{

 \url{https://wiki.teamfortress.com/wiki/WebAPI/GetItemIconPath}
}

