% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/climacell_celestial.R
\name{climacell_celestial}
\alias{climacell_celestial}
\title{Sunrise, Sunset, and Moon Phase Readings from Climacell}
\usage{
climacell_celestial(
  api_key,
  lat,
  long,
  timestep = "1d",
  start_time = NULL,
  end_time = NULL
)
}
\arguments{
\item{api_key}{character string representing the private API key. Provided by user or loaded automatically from environment variable (environment variable must be called "CLIMACELL_API").}

\item{lat}{a numeric value (or a string that can be coerced to numeric) representing the latitude of the location.}

\item{long}{a numeric value (or a string that can be coerced to numeric) representing the longitude of the location.}

\item{timestep}{a 'step' value for the time. For the \code{climacell_celestial} function, the only acceptable value (per the limitations of the Climacell API) is '1d'.}

\item{start_time}{the start time of the query. This input must be a character string that can be parsed into a data/time or a date/time value. If the input does not contain a timezone, the value will be assumed to be in UTC. It is recommended that the \code{lubridate::now()} function or \code{Sys.time()} be used to define the start_time. For this function, the start_time cannot be less than 6 hours from the current time.}

\item{end_time}{the end time of the query. This input must be a character string that can be parsed into a data/time or a date/time value. If the input does not contain a timezone, the value will be assumed to be in UTC. For this function, the end_time cannot be greater than 15 days from the current date/time.}
}
\value{
a tibble
}
\description{
This function will make a call to the Climacell API and retrieve sunrise, sunset times and moon phase variables.
}
\details{
\code{climacell_celestial} returns a tibble that consists of sunrise/sunset times along with the moon phase (code & description).
}
\examples{
\dontrun{
climacell_celestial(
  api_key = Sys.getenv('CLIMACELL_API'),
  lat = 0,
  long = 0,
  timestep = '1d',
  start_time = lubridate::now(),
  end_time = lubridate::now() + lubridate::days(5))
}
}
