% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TEstimate_wrapper.R
\name{TEstimator_wrapper}
\alias{TEstimator_wrapper}
\title{Estimating conditional average treatment effects}
\usage{
TEstimator_wrapper(
  Estimator,
  data,
  vars_name,
  name = "",
  outcome_method = "glm",
  treatment_method = "glm",
  two_models = FALSE,
  outcome_formula = NULL,
  treatment_formula = NULL,
  data.public = TRUE,
  isTrial = FALSE,
  strata_cut = NULL,
  ...
)
}
\arguments{
\item{Estimator}{A character specifying an estimator for conditional average treatment effects. The allowed estimators are: \code{"G_computation"}, \code{"IPW"}, and \code{"DR"}.i The corresponding object wll be created by the function \code{TEstimator_wrapper()}. The default is \code{"G_computation"}, which, along with \code{outcome_method="glm"} models the potential outcomes.}

\item{data}{A data frame containing variables named in \code{vars_name} and possible other variables.}

\item{vars_name}{A list containing four character vectors \code{outcome_predictors}, \code{treatment_name}, and \code{outcome_name}. \code{outcome_predictors} is a character vector containing the adjustment variables, which, along with \code{TEstimator} and the corresponding \code{outcome_method} or \code{treatment_method} to correct for confounding; \code{outcome_name} is a character vector of length one containing the name of outcome; \code{treatment_name} is a character vector of length one containing the name of treatment.}

\item{name}{A character indicating the name of the output object}

\item{outcome_method}{A character specifying a model for outcome. Possible values are found using \code{names(getModelInfo())}. See \url{http://topepo.github.io/caret/train-models-by-tag.html}. Default is "glm".}

\item{treatment_method}{A character specifying a model for treatment. Possible values are found using \code{names(getModelInfo())}. See \url{http://topepo.github.io/caret/train-models-by-tag.html}. Default is "glm".}

\item{two_models}{An optional logical indicating whether potential outcomes should be modeled separately when \code{TEstimator="DR"}. Default is \code{FALSE}.}

\item{outcome_formula}{An optional object of class \code{formula} describing the outcome model specification when \code{Estimator="G_computation"} or \code{Estimator="DR"}.}

\item{treatment_formula}{An optional object of class \code{formula} describing the treatment model specification when \code{Estimator="IPW"} or \code{Estimator="DR"}}

\item{data.public}{An optional logical indicating whether individual-level \code{data} is public in the output object. Default is \code{TRUE}.}

\item{isTrial}{An optional logical indicating whether the treatment assignment of \code{data} is random or unknown.}

\item{strata_cut}{An optional list containing lists. Each component is a list with tag named by a variable in \code{data} to discretize, containing \code{break} which is a vector specifying the interval of range of the variable to divide, \code{lable} which is a character vector specifying how to code value in the variable according to which interval they fall. The leftmost interval corresponds to level one, the next leftmost to level two and so on. This parameter is useful in the case we concern the integrated treatment effect conditioning on variables with multiple levels (for instance, continuous variable or ordinal variable with multiple levels). Note that we first model based on these continuous variables, then we discretize these variables according to \code{strata_cut}. The variables in \code{data} of the output object are discretized.}

\item{...}{An optional argument passed to the private function \code{fit()} of each class for model training and tuning. See \url{https://topepo.github.io/caret/model-training-and-tuning.html} for details.}
}
\value{
An object of class \code{TEstimator}.
}
\description{
Estimating conditional average treatment effects
}
\examples{
\donttest{
data <- RCTrep::source.data[sample(dim(RCTrep::source.data)[1],500),]
vars_name <- list(outcome_predictors = c("x1","x2","x3","x4","x5","x6"),
                  treatment_name = c('z'),
                  outcome_name = c('y'))

obj <- TEstimator_wrapper(
 Estimator = "G_computation",
 data = data,
 vars_name = vars_name,
 name = "RCT",
 data.public = TRUE,
 isTrial = FALSE)
}

}
