% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_IFE_algorithm_functions.R
\name{adapt_pic_with_sigma2maxmodel}
\alias{adapt_pic_with_sigma2maxmodel}
\title{Adapts the object that contains PIC for all candidate C's and all subsamples with sigma2_max_model.}
\usage{
adapt_pic_with_sigma2maxmodel(df, df_results, sigma2_max_model)
}
\arguments{
\item{df}{contains PIC for all candidate C's and all subsamples}

\item{df_results}{dataframe with results for each estimated configuration}

\item{sigma2_max_model}{sigma2 of model with maximum number of groups and factors}
}
\value{
data.frame of same size as df
}
\description{
The PIC is calculated with a sigma2 specific to the configuration (= number of groups and factors).
Because the method to estimate the number of groups and factors requires sigma2 to be equal over all configurations
(see proofs of different papers of Ando/Bai) we replace sigma2
by the sigma2 of the configuration with maximum number of groups and factors (this is the last one that was executed).
}
\examples{
set.seed(1)
df_pic <- data.frame(matrix(rnorm(4 * 50), nrow = 4)) #4 configuration / 50 candidate values for C
df_results <- data.frame(sigma2 = rnorm(4))
pic_sigma2 <- 3.945505
adapt_pic_with_sigma2maxmodel(df_pic, df_results, pic_sigma2)
}
