% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxplotC.r
\name{boxplotC}
\alias{boxplotC}
\title{Generates box plots to compare interval-level dependent variable's distribution across categories of independent variable.}
\usage{
boxplotC(dv, iv, w, data, main, xlab, ylab, box.col, varwidth = TRUE, ivlabs,
  printC = FALSE, ...)
}
\arguments{
\item{dv}{Dependent variable, should be in dataset$var form unless dataset specified in optional data argument.}

\item{iv}{Independent variable, should be in dataset$var form unless dataset specified in optional data argument.}

\item{w}{(Optional) Sampling weights of variable, must be numeric; should be in dataset$weightvar form unless dataset specified in optional data argument.}

\item{data}{(Optional) Name of dataset that contains dv, iv (and w) variables (optional).}

\item{main}{(Optional) Supply custom main label for plot; default uses names of dv and iv.}

\item{xlab}{(Optional) Supply custom x-axis label for plot; default uses name of iv.}

\item{ylab}{(Optional) Supply y-axis label for plot; default uses name of dv.}

\item{box.col}{(Optional) The name of color to use for box colors. Default is "gray80".}

\item{varwidth}{(Optional) Do you want the widths of boxes to be proportional to number of observations in each group? Default is TRUE; set \code{varwidth=FALSE} for equal-width boxes.}

\item{ivlabs}{(Optional) A vector of labels for the iv values that are box lablels.}

\item{printC}{(Optional) Do you want to print box plot to .html file in working directory? (Default: FALSE)}

\item{...}{Additional arguments passed to plotting functions, \code{\link[graphics]{boxplot}} or \code{\link[graphics]{bxp}}.}
}
\value{
No return, creates a plot.
}
\description{
Generates box plots for visual comparison of interval-level dependent variable's distribution across categories of independent variable. Includes option for weighting observations, modifying colors, variable widths. Box plot can be used to compare values of interval-level dependent variable by categories of an independent variable (a factor).
}
\section{RCPA3 Package Tutorial Videos}{

\itemize{
\item \href{https://youtu.be/40bQJucHbY4}{Making Box Plots with RCPA3's boxplotC Function} 15:12, shows you how to use the RCPA3 Package's boxplotC function to create box plots that show the relationship between an interval-level dependent variables and a categorical independent variable.
\item \href{https://www.youtube.com/playlist?list=PL3jY4WDTUxoNqrxSSQH4q7XPLPYipeNCu}{Complete Playlist of RCPA3 Package Tutorial Videos}, includes video for this function and many more.
}
}

\section{Textbook References}{

\itemize{
\item Philip H. Pollock and Barry C. Edwards, \emph{An R Companion to Political Analysis, 3rd Edition} (Thousand Oaks, CA: Sage Publications, Forthcoming 2022), Chapter 5.
\item Philip H. Pollock and Barry C. Edwards, \emph{The Essentials of Political Analysis, 6th Edition} (Thousand Oaks, CA: Sage Publications, 2020), pp. 53-55. ISBN-13: 978-1506379616; ISBN-10: 150637961.
}
}

\section{Online Resources}{

\itemize{
\item \href{https://www.poliscidata.com/pages/rDemosResources.php?chapter=5}{R Tutorials & Resources for Graphing Relationships and Describing Patterns}, compiled by Barry C. Edwards
\item \href{https://edge.sagepub.com/pollock}{Sage Edge Resources for Political Analysis Series}, for streaming videos, flashcards, and more student resources for textbooks by Pollock and Edwards, from Sage Publications.
\item \href{https://www.poliscidata.com}{Political Science Data Web Site}, find datasets for your own research and resources to help with political analysis.
}
}

\examples{
  library(RCPA3)
   
  # basic usage with variables as vectors
  boxplotC(dv=nes$ft.rep, iv=nes$partyid3)
  
  # with w and data arguments
  boxplotC(dv=ft.rep, iv=partyid3, w=wt, data=nes)
}
