% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seroprevalence.R
\name{seroprevalence}
\alias{seroprevalence}
\title{Seroprevalence Calculation}
\usage{
seroprevalence(ages, A_max, SCR, SRR)
}
\arguments{
\item{ages}{Vector with the proportions of different ages in the population (age structure).}

\item{A_max}{Maximum age considered in the population.}

\item{SCR}{Seroconversion rate.}

\item{SRR}{Seroreversion rate.}
}
\value{
The total seroprevalence weighted by the age distribution.
}
\description{
Calculates the seroprevalence considering an age distribution and a reversible
catalytic model.
}
\examples{
A_max <- 80
age_distribution <- rep(1 / A_max, A_max)
seroprevalence(age_distribution, A_max, 0.03, 0.01)
}
