% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regu-est-c.r
\name{ate.regu.cv}
\alias{ate.regu.cv}
\title{Model-assisted inference for average treatment effects based on cross validation}
\usage{
ate.regu.cv(fold, nrho = NULL, rho.seq = NULL, y, tr, x, ploss = "cal",
  yloss = "gaus", off = NULL, ...)
}
\arguments{
\item{fold}{A vector of length 2 giving the fold numbers for cross validation in propensity score estimation and outcome regression respectively.}

\item{nrho}{A vector of length 2 giving the numbers of tuning parameters searched in cross validation.}

\item{rho.seq}{A list of two vectors giving the tuning parameters in propensity score estimation (first vector) and outcome regression (second vector).}

\item{y}{An \eqn{n} x \eqn{1} vector of observed outcomes.}

\item{tr}{An \eqn{n} x \eqn{1} vector of treatment indicators (=1 if treated or 0 if untreated).}

\item{x}{An \eqn{n} x \eqn{p} matix of covariates, used in both propensity score and outcome regression models.}

\item{ploss}{A loss function used in propensity score estimation (either "ml" or "cal").}

\item{yloss}{A loss function used in outcome regression (either "gaus" for continuous outcomes or "ml" for binary outcomes).}

\item{off}{A \eqn{2} x \eqn{1} vector of offset values (e.g., the true values in simulations) used to calculate the z-statistics from augmented IPW estimation.}

\item{...}{Additional arguments to \code{\link{glm.regu.cv}}.}
}
\value{
\item{ps}{A list containing the results from fitting the propensity score model by \code{\link{glm.regu.cv}}.}
\item{mfp}{An \eqn{n} x \eqn{2} matrix of fitted propensity scores for untreated (first column) and treated (second column).}
\item{or}{A list containing the results from fitting the outcome regression model by \code{\link{glm.regu.cv}}.}
\item{mfo}{An \eqn{n} x \eqn{2} matrix of fitted values from outcome regression, for untreated (first column) and treated (second column).}
\item{est}{A list containing the results from augmented IPW estimation by \code{\link{ate.aipw}}.}
}
\description{
This function implements model-assisted inference for average treatment effects,
using regularized calibrated estimation based on cross validation.
}
\details{
For calibrated estimation, two sets of propensity scores are separately estimated for the untreated and treated as discussed in Tan (2020a, 2020b).
See also \strong{Details} for \code{\link{mn.regu.cv}}.
}
\examples{
\donttest{
data(simu.data)
n <- dim(simu.data)[1]
p <- dim(simu.data)[2]-2

y <- simu.data[,1]
tr <- simu.data[,2]
x <- simu.data[,2+1:p]
x <- scale(x)

ate.cv.rcal <- ate.regu.cv(fold=5*c(1,1), nrho=(1+10)*c(1,1), rho.seq=NULL, y, tr, x, 
                           ploss="cal", yloss="gaus")

matrix(unlist(ate.cv.rcal$est), ncol=2, byrow=TRUE, 
dimnames=list(c("one", "ipw", "or", "est", "var", "ze", 
"diff.est", "diff.var", "diff.ze"), c("untreated", "treated")))
}

}
\references{
Tan, Z. (2020a) Regularized calibrated estimation of propensity scores with model misspecification and high-dimensional data, \emph{Biometrika}, 107, 137–158.

Tan, Z. (2020b) Model-assisted inference for treatment effects using regularized calibrated estimation with high-dimensional data, \emph{Annals of Statistics}, 48, 811–837.
}
