% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regu-est-c.r
\name{ate.ipw}
\alias{ate.ipw}
\title{Inverse probability weighted estimation of average treatment effects}
\usage{
ate.ipw(y, tr, mfp)
}
\arguments{
\item{y}{An \eqn{n} x \eqn{1} vector of observed outcomes.}

\item{tr}{An \eqn{n} x \eqn{1} vector of treatment indicators (=1 if treated or 0 if untreated).}

\item{mfp}{An \eqn{n} x \eqn{2} matrix of fitted propensity scores for untreated (first column) and treated (second column).}
}
\value{
\item{one}{The direct IPW estimates of 1.}
\item{est}{The ratio IPW estimates of means.}
\item{diff}{The ratio IPW estimate of ATE.}
}
\description{
This function implements inverse probability weighted (IPW) estimation of average treatment effects (ATEs),
provided fitted propensity scores.
}
\references{
Tan, Z. (2020a) Regularized calibrated estimation of propensity scores with model misspecification and high-dimensional data, \emph{Biometrika}, 107, 137–158.

Tan, Z. (2020b) Model-assisted inference for treatment effects using regularized calibrated estimation with high-dimensional data, \emph{Annals of Statistics}, 48, 811–837.
}
