% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_mcmcOptions.R
\name{mcmcOptions}
\alias{mcmcOptions}
\title{mcmcOptions object constructor.}
\usage{
mcmcOptions(
  fname = "Config_MCMC.txt",
  result.fname = "Results_MCMC.txt",
  nAdapt = 100,
  nCycles = 100,
  minMoveRate = 0.1,
  maxMoveRate = 0.5,
  downMult = 0.9,
  upMult = 1.1,
  multFactor = 0.1,
  manualMode = FALSE,
  thetaStd = 9999,
  gammaStd = list(9999)
)
}
\arguments{
\item{fname}{Character, configuration file name.}

\item{result.fname}{Character, result file name.}

\item{nAdapt}{Integer, adaptation period: jump sizes are increased/decreased
every Nadapt iterations to comply with the desired moving rates.}

\item{nCycles}{Integer, number of adaptation cycles
(total number of iterations is hence Nadapt * Ncycles).}

\item{minMoveRate}{Numeric in (0;1), lower bound for the desired move rate interval.}

\item{maxMoveRate}{Numeric in (0;1), upper bound for the desired move rate interval.}

\item{downMult}{Numeric in (0:1), multiplication factor used to decrease jump size
when move rate is too low.}

\item{upMult}{Numeric (>1, avoid 1/dowMult) multiplication factor used to increase
jump size when move rate is too high.}

\item{multFactor}{Numeric >0, multiplicative factor to set initial jump standard deviations
to multFactor*|initValue| (AUTO mode).}

\item{manualMode}{logical, should jump standard deviations be entered manually?}

\item{thetaStd}{Numeric vector (>0), jump standard deviations for model parameters theta (MANUAL mode).}

\item{gammaStd}{list of numeric vectors (>0), size = number of output variables of the model.
Jump standard deviations for structural error parameters gamma of each output variable (MANUAL mode).}
}
\value{
An object of class 'mcmcOptions'.
}
\description{
Creates a new instance of a 'mcmcOptions' object
}
\examples{
m <- mcmcOptions()
}
