% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_public.R
\name{downloadBaM}
\alias{downloadBaM}
\title{BaM downloader}
\usage{
downloadBaM(
  destFolder,
  url = NULL,
  os = Sys.info()["sysname"],
  quiet = FALSE,
  ...
)
}
\arguments{
\item{destFolder}{character string, folder where BaM executable will be downloaded.}

\item{url}{character string, the url from which BaM should be downloaded.
When NULL, the url is determined automatically by using GitHub API to determine
the latest release and the file corresponding to the OS.}

\item{os}{character string, operating system, e.g. 'Linux', 'Windows' or 'Darwin'.}

\item{quiet}{logical, if TRUE, suppress status messages.}

\item{...}{arguments passed to function `download.file`}
}
\value{
nothing - just download the file.
}
\description{
Download BaM executable
}
\examples{
  try(downloadBaM(destFolder=tempdir()))
}
